/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform;

import java.util.Optional;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.picocontainer.Startable;
import org.sonar.api.config.Configuration;
import org.sonar.api.platform.ServerUpgradeStatus;
import org.sonar.process.ProcessProperties;
import org.sonar.server.platform.db.migration.step.MigrationSteps;
import org.sonar.server.platform.db.migration.version.DatabaseVersion;

public class DefaultServerUpgradeStatus
implements ServerUpgradeStatus,
Startable {
    private final DatabaseVersion dbVersion;
    private final MigrationSteps migrationSteps;
    private final Configuration configuration;
    private long initialDbVersion;

    public DefaultServerUpgradeStatus(DatabaseVersion dbVersion, MigrationSteps migrationSteps, Configuration configuration) {
        this.dbVersion = dbVersion;
        this.migrationSteps = migrationSteps;
        this.configuration = configuration;
    }

    public void start() {
        Optional v = this.dbVersion.getVersion();
        this.initialDbVersion = v.orElse(-1L);
    }

    public void stop() {
    }

    public boolean isUpgraded() {
        return !this.isFreshInstall() && this.initialDbVersion < this.migrationSteps.getMaxMigrationNumber();
    }

    public boolean isFreshInstall() {
        return this.initialDbVersion < 0L;
    }

    public int getInitialDbVersion() {
        return (int)this.initialDbVersion;
    }

    public boolean isBlueGreen() {
        return this.configuration.getBoolean(ProcessProperties.Property.BLUE_GREEN_ENABLED.getKey()).orElse(false);
    }

    public String toString() {
        return new ReflectionToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).toString();
    }
}

