/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.project;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.sonar.db.component.ComponentDto;

@Immutable
public class Project {
    private final String uuid;
    private final String key;
    private final String name;
    private final String description;
    private final List<String> tags;

    public Project(String uuid, String key, String name, @Nullable String description, List<String> tags) {
        this.uuid = uuid;
        this.key = key;
        this.name = name;
        this.description = description;
        this.tags = tags;
    }

    public static Project from(ComponentDto project) {
        return new Project(project.uuid(), project.getKey(), project.name(), project.description(), project.getTags());
    }

    public String getUuid() {
        return this.uuid;
    }

    public String getKey() {
        return this.key;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Project project = (Project)o;
        return this.uuid.equals(project.uuid) && this.key.equals(project.key) && this.name.equals(project.name);
    }

    public int hashCode() {
        return Objects.hash(this.uuid, this.key, this.name);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Project{");
        sb.append("uuid='").append(this.uuid).append('\'');
        sb.append(", key='").append(this.key).append('\'');
        sb.append(", name='").append(this.name).append('\'');
        sb.append(", description=").append(Project.toString(this.description));
        sb.append('}');
        return sb.toString();
    }

    private static String toString(@Nullable String s) {
        if (s == null) {
            return null;
        }
        return '\'' + s + '\'';
    }
}

