/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.qualitygate;

import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.concurrent.Immutable;

@Immutable
public class Condition {
    private final String metricKey;
    private final Operator operator;
    private final String errorThreshold;
    private final boolean onLeakPeriod;

    public Condition(String metricKey, Operator operator, String errorThreshold) {
        this.metricKey = Objects.requireNonNull(metricKey, "metricKey can't be null");
        this.operator = Objects.requireNonNull(operator, "operator can't be null");
        this.errorThreshold = Objects.requireNonNull(errorThreshold, "errorThreshold can't be null");
        this.onLeakPeriod = metricKey.startsWith("new_");
    }

    public String getMetricKey() {
        return this.metricKey;
    }

    public boolean isOnLeakPeriod() {
        return this.onLeakPeriod;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public String getErrorThreshold() {
        return this.errorThreshold;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Condition condition = (Condition)o;
        return Objects.equals(this.metricKey, condition.metricKey) && this.operator == condition.operator && Objects.equals(this.errorThreshold, condition.errorThreshold);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.metricKey, this.operator, this.errorThreshold});
    }

    public String toString() {
        return "Condition{metricKey='" + this.metricKey + '\'' + ", operator=" + (Object)((Object)this.operator) + ", errorThreshold=" + Condition.toString(this.errorThreshold) + '}';
    }

    private static String toString(String errorThreshold) {
        return '\'' + errorThreshold + '\'';
    }

    public static enum Operator {
        GREATER_THAN("GT"),
        LESS_THAN("LT");

        private final String dbValue;

        private Operator(String dbValue) {
            this.dbValue = dbValue;
        }

        public String getDbValue() {
            return this.dbValue;
        }

        public static Operator fromDbValue(String s) {
            return Stream.of(Operator.values()).filter(o -> o.getDbValue().equals(s)).findFirst().orElseThrow(() -> new IllegalArgumentException("Unsupported operator db value: " + s));
        }

        public static boolean isValid(String s) {
            return Stream.of(Operator.values()).anyMatch(o -> o.getDbValue().equals(s));
        }
    }
}

