/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.qualitygate;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.sonar.server.qualitygate.Condition;

@Immutable
public class EvaluatedCondition {
    private final Condition condition;
    private final EvaluationStatus status;
    @Nullable
    private final String value;

    public EvaluatedCondition(Condition condition, EvaluationStatus status, @Nullable String value) {
        this.condition = Objects.requireNonNull(condition, "condition can't be null");
        this.status = Objects.requireNonNull(status, "status can't be null");
        this.value = value;
    }

    public Condition getCondition() {
        return this.condition;
    }

    public EvaluationStatus getStatus() {
        return this.status;
    }

    public Optional<String> getValue() {
        return Optional.ofNullable(this.value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EvaluatedCondition that = (EvaluatedCondition)o;
        return Objects.equals(this.condition, that.condition) && this.status == that.status && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.condition, this.status, this.value});
    }

    public String toString() {
        return "EvaluatedCondition{condition=" + this.condition + ", status=" + (Object)((Object)this.status) + ", value=" + (this.value == null ? null : '\'' + this.value + '\'') + '}';
    }

    public static enum EvaluationStatus {
        NO_VALUE,
        OK,
        ERROR;

    }
}

