/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.qualitygate;

import com.google.common.base.Preconditions;
import java.util.Optional;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.qualitygate.QGateWithOrgDto;
import org.sonar.db.qualitygate.QualityGateDto;

public class QualityGateFinder {
    public static final String SONAR_QUALITYGATE_PROPERTY = "sonar.qualitygate";
    private final DbClient dbClient;

    public QualityGateFinder(DbClient dbClient) {
        this.dbClient = dbClient;
    }

    public Optional<QualityGateData> getQualityGate(DbSession dbSession, OrganizationDto organization, ComponentDto component) {
        Optional<QualityGateData> res = this.dbClient.projectQgateAssociationDao().selectQGateIdByComponentId(dbSession, component.getId().longValue()).map(qualityGateId -> this.dbClient.qualityGateDao().selectById(dbSession, qualityGateId.longValue())).map(qualityGateDto -> new QualityGateData((QualityGateDto)qualityGateDto, false));
        if (res.isPresent()) {
            return res;
        }
        return Optional.ofNullable(this.dbClient.qualityGateDao().selectByOrganizationAndUuid(dbSession, organization, organization.getDefaultQualityGateUuid())).map(qualityGateDto -> new QualityGateData((QualityGateDto)qualityGateDto, true));
    }

    public QualityGateDto getDefault(DbSession dbSession, OrganizationDto organization) {
        QGateWithOrgDto qgate = this.dbClient.qualityGateDao().selectByOrganizationAndUuid(dbSession, organization, organization.getDefaultQualityGateUuid());
        Preconditions.checkState((qgate != null ? 1 : 0) != 0, (String)"Default quality gate [%s] is missing on organization [%s]", (Object[])new Object[]{organization.getDefaultQualityGateUuid(), organization.getUuid()});
        return qgate;
    }

    public QualityGateDto getBuiltInQualityGate(DbSession dbSession) {
        QualityGateDto builtIn = this.dbClient.qualityGateDao().selectBuiltIn(dbSession);
        Preconditions.checkState((builtIn != null ? 1 : 0) != 0, (Object)"Builtin quality gate is missing.");
        return builtIn;
    }

    public static class QualityGateData {
        private final QualityGateDto qualityGate;
        private final boolean isDefault;

        private QualityGateData(QualityGateDto qualityGate, boolean isDefault) {
            this.qualityGate = qualityGate;
            this.isDefault = isDefault;
        }

        public QualityGateDto getQualityGate() {
            return this.qualityGate;
        }

        public boolean isDefault() {
            return this.isDefault;
        }
    }
}

