/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.rule.index;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.lucene.search.join.ScoreMode;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.Operator;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.index.query.TermsQueryBuilder;
import org.elasticsearch.join.aggregations.JoinAggregationBuilders;
import org.elasticsearch.join.query.HasParentQueryBuilder;
import org.elasticsearch.join.query.JoinQueryBuilders;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.BucketOrder;
import org.elasticsearch.search.aggregations.bucket.filter.FilterAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.terms.IncludeExclude;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.sonar.api.rule.RuleStatus;
import org.sonar.api.rule.Severity;
import org.sonar.api.rules.RuleType;
import org.sonar.api.utils.System2;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.qualityprofile.QProfileDto;
import org.sonar.server.es.EsClient;
import org.sonar.server.es.EsUtils;
import org.sonar.server.es.SearchIdResult;
import org.sonar.server.es.SearchOptions;
import org.sonar.server.es.StickyFacetBuilder;
import org.sonar.server.es.newindex.DefaultIndexSettingsElement;
import org.sonar.server.es.textsearch.JavaTokenizer;
import org.sonar.server.rule.index.RuleExtensionScope;
import org.sonar.server.rule.index.RuleIndexDefinition;
import org.sonar.server.rule.index.RuleQuery;

public class RuleIndex {
    public static final String FACET_LANGUAGES = "languages";
    public static final String FACET_TAGS = "tags";
    public static final String FACET_REPOSITORIES = "repositories";
    public static final String FACET_SEVERITIES = "severities";
    public static final String FACET_ACTIVE_SEVERITIES = "active_severities";
    public static final String FACET_STATUSES = "statuses";
    public static final String FACET_TYPES = "types";
    public static final String FACET_OLD_DEFAULT = "true";
    private static final int MAX_FACET_SIZE = 100;
    public static final List<String> ALL_STATUSES_EXCEPT_REMOVED = (List)Arrays.stream(RuleStatus.values()).filter(status -> !RuleStatus.REMOVED.equals(status)).map(Enum::toString).collect(MoreCollectors.toList());
    private static final String AGGREGATION_NAME_FOR_TAGS = "tagsAggregation";
    private final EsClient client;
    private final System2 system2;

    public RuleIndex(EsClient client, System2 system2) {
        this.client = client;
        this.system2 = system2;
    }

    public SearchIdResult<Integer> search(RuleQuery query, SearchOptions options) {
        SearchRequestBuilder esSearch = this.client.prepareSearch(RuleIndexDefinition.TYPE_RULE);
        QueryBuilder qb = RuleIndex.buildQuery(query);
        Map<String, QueryBuilder> filters = RuleIndex.buildFilters(query);
        if (!options.getFacets().isEmpty()) {
            for (AggregationBuilder aggregation : RuleIndex.getFacets(query, options, qb, filters).values()) {
                esSearch.addAggregation(aggregation);
            }
        }
        RuleIndex.setSorting(query, esSearch);
        RuleIndex.setPagination(options, esSearch);
        BoolQueryBuilder fb = QueryBuilders.boolQuery();
        for (QueryBuilder filterBuilder : filters.values()) {
            fb.must(filterBuilder);
        }
        esSearch.setQuery((QueryBuilder)QueryBuilders.boolQuery().must(qb).filter((QueryBuilder)fb));
        return new SearchIdResult<Integer>((SearchResponse)esSearch.get(), Integer::parseInt, this.system2.getDefaultTimeZone());
    }

    public Iterator<Integer> searchAll(RuleQuery query) {
        SearchRequestBuilder esSearch = this.client.prepareSearch(RuleIndexDefinition.TYPE_RULE).setScroll(TimeValue.timeValueMinutes((long)3L));
        EsUtils.optimizeScrollRequest(esSearch);
        QueryBuilder qb = RuleIndex.buildQuery(query);
        Map<String, QueryBuilder> filters = RuleIndex.buildFilters(query);
        BoolQueryBuilder fb = QueryBuilders.boolQuery();
        for (QueryBuilder filterBuilder : filters.values()) {
            fb.must(filterBuilder);
        }
        esSearch.setQuery((QueryBuilder)QueryBuilders.boolQuery().must(qb).filter((QueryBuilder)fb));
        SearchResponse response = (SearchResponse)esSearch.get();
        return EsUtils.scrollIds(this.client, response, Integer::parseInt);
    }

    private static QueryBuilder buildQuery(RuleQuery query) {
        String queryText = query.getQueryText();
        if (StringUtils.isEmpty((String)queryText)) {
            return QueryBuilders.matchAllQuery();
        }
        BoolQueryBuilder qb = QueryBuilders.boolQuery();
        String queryString = query.getQueryText();
        if (queryString != null && !queryString.isEmpty()) {
            BoolQueryBuilder textQuery = QueryBuilders.boolQuery();
            JavaTokenizer.split(queryString).stream().map(token -> QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.matchQuery((String)DefaultIndexSettingsElement.SEARCH_GRAMS_ANALYZER.subField("name"), (Object)StringUtils.left((String)token, (int)15)).boost(20.0f)).should((QueryBuilder)QueryBuilders.matchPhraseQuery((String)DefaultIndexSettingsElement.ENGLISH_HTML_ANALYZER.subField("htmlDesc"), (Object)token).boost(3.0f))).forEach(arg_0 -> ((BoolQueryBuilder)textQuery).must(arg_0));
            qb.should((QueryBuilder)textQuery.boost(20.0f));
        }
        qb.should((QueryBuilder)QueryBuilders.matchQuery((String)DefaultIndexSettingsElement.SORTABLE_ANALYZER.subField("key"), (Object)queryString).operator(Operator.AND).boost(30.0f));
        qb.should((QueryBuilder)QueryBuilders.matchQuery((String)DefaultIndexSettingsElement.SORTABLE_ANALYZER.subField("ruleKey"), (Object)queryString).operator(Operator.AND).boost(15.0f));
        qb.should(RuleIndex.termQuery("lang", queryString, 3.0f));
        return qb;
    }

    private static QueryBuilder termQuery(String field, String query, float boost) {
        return QueryBuilders.multiMatchQuery((Object)query, (String[])new String[]{field, DefaultIndexSettingsElement.SEARCH_WORDS_ANALYZER.subField(field)}).operator(Operator.AND).boost(boost);
    }

    private static Map<String, QueryBuilder> buildFilters(RuleQuery query) {
        String template;
        boolean includeExternal;
        Boolean isTemplate;
        Collection<RuleType> types;
        HashMap<String, QueryBuilder> filters = new HashMap<String, QueryBuilder>();
        filters.put("indexType", (QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termsQuery((String)"indexType", (String[])new String[]{RuleIndexDefinition.TYPE_RULE.getType()})));
        filters.put("status", (QueryBuilder)QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.termQuery((String)"status", (String)RuleStatus.REMOVED.toString())));
        if (StringUtils.isNotEmpty((String)query.getInternalKey())) {
            filters.put("internalKey", (QueryBuilder)QueryBuilders.termQuery((String)"internalKey", (String)query.getInternalKey()));
        }
        if (StringUtils.isNotEmpty((String)query.getRuleKey())) {
            filters.put("ruleKey", (QueryBuilder)QueryBuilders.termQuery((String)"ruleKey", (String)query.getRuleKey()));
        }
        if (RuleIndex.isNotEmpty(query.getLanguages())) {
            filters.put("lang", (QueryBuilder)QueryBuilders.termsQuery((String)"lang", query.getLanguages()));
        }
        if (RuleIndex.isNotEmpty(query.getRepositories())) {
            filters.put("repo", (QueryBuilder)QueryBuilders.termsQuery((String)"repo", query.getRepositories()));
        }
        if (RuleIndex.isNotEmpty(query.getSeverities())) {
            filters.put("severity", (QueryBuilder)QueryBuilders.termsQuery((String)"severity", query.getSeverities()));
        }
        if (StringUtils.isNotEmpty((String)query.getKey())) {
            filters.put("key", (QueryBuilder)QueryBuilders.termQuery((String)"key", (String)query.getKey()));
        }
        if (RuleIndex.isNotEmpty(query.getTags())) {
            filters.put("ruleExt_tags", (QueryBuilder)RuleIndex.buildTagsFilter(query.getTags(), query.getOrganization()));
        }
        if (RuleIndex.isNotEmpty(types = query.getTypes())) {
            List typeNames = (List)types.stream().map(Enum::toString).collect(MoreCollectors.toList());
            filters.put("type", (QueryBuilder)QueryBuilders.termsQuery((String)"type", (Collection)typeNames));
        }
        if (query.getAvailableSinceLong() != null) {
            filters.put("availableSince", (QueryBuilder)QueryBuilders.rangeQuery((String)"createdAt").gte((Object)query.getAvailableSinceLong()));
        }
        if (RuleIndex.isNotEmpty(query.getStatuses())) {
            ArrayList<String> stringStatus = new ArrayList<String>();
            for (RuleStatus status : query.getStatuses()) {
                stringStatus.add(status.name());
            }
            filters.put("status", (QueryBuilder)QueryBuilders.termsQuery((String)"status", stringStatus));
        }
        if ((isTemplate = query.isTemplate()) != null) {
            filters.put("isTemplate", (QueryBuilder)QueryBuilders.termQuery((String)"isTemplate", (String)Boolean.toString(isTemplate)));
        }
        if (!(includeExternal = query.includeExternal())) {
            filters.put("isExternal", (QueryBuilder)QueryBuilders.termQuery((String)"isExternal", (boolean)false));
        }
        if ((template = query.templateKey()) != null) {
            filters.put("templateKey", (QueryBuilder)QueryBuilders.termQuery((String)"templateKey", (String)template));
        }
        QProfileDto profile = query.getQProfile();
        if (query.getActivation() != null && profile != null) {
            QueryBuilder childQuery = RuleIndex.buildActivationFilter(query, profile);
            if (Boolean.TRUE.equals(query.getActivation())) {
                filters.put("activation", (QueryBuilder)JoinQueryBuilders.hasChildQuery((String)RuleIndexDefinition.TYPE_ACTIVE_RULE.getName(), (QueryBuilder)childQuery, (ScoreMode)ScoreMode.None));
            } else if (Boolean.FALSE.equals(query.getActivation())) {
                filters.put("activation", (QueryBuilder)QueryBuilders.boolQuery().mustNot((QueryBuilder)JoinQueryBuilders.hasChildQuery((String)RuleIndexDefinition.TYPE_ACTIVE_RULE.getName(), (QueryBuilder)childQuery, (ScoreMode)ScoreMode.None)));
            }
            QProfileDto compareToQProfile = query.getCompareToQProfile();
            if (compareToQProfile != null) {
                filters.put("comparison", (QueryBuilder)JoinQueryBuilders.hasChildQuery((String)RuleIndexDefinition.TYPE_ACTIVE_RULE.getName(), (QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)"activeRule_ruleProfile", (String)compareToQProfile.getRulesProfileUuid())), (ScoreMode)ScoreMode.None));
            }
        }
        return filters;
    }

    private static BoolQueryBuilder buildTagsFilter(Collection<String> tags, OrganizationDto organization) {
        BoolQueryBuilder q = QueryBuilders.boolQuery();
        tags.stream().map(tag -> QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.termQuery((String)"ruleExt_tags", (String)tag)).filter((QueryBuilder)QueryBuilders.termsQuery((String)"ruleExt_scope", (String[])new String[]{RuleExtensionScope.system().getScope(), RuleExtensionScope.organization(organization).getScope()}))).map(childQuery -> JoinQueryBuilders.hasChildQuery((String)RuleIndexDefinition.TYPE_RULE_EXTENSION.getName(), (QueryBuilder)childQuery, (ScoreMode)ScoreMode.None)).forEach(arg_0 -> ((BoolQueryBuilder)q).should(arg_0));
        return q;
    }

    private static QueryBuilder buildActivationFilter(RuleQuery query, QProfileDto profile) {
        BoolQueryBuilder activeRuleFilter = QueryBuilders.boolQuery();
        RuleIndex.addTermFilter(activeRuleFilter, "activeRule_ruleProfile", profile.getRulesProfileUuid());
        RuleIndex.addTermFilter(activeRuleFilter, "activeRule_inheritance", query.getInheritance());
        RuleIndex.addTermFilter(activeRuleFilter, "activeRule_severity", query.getActiveSeverities());
        Object childQuery = activeRuleFilter.hasClauses() ? activeRuleFilter : QueryBuilders.matchAllQuery();
        return childQuery;
    }

    private static BoolQueryBuilder addTermFilter(BoolQueryBuilder filter, String field, @Nullable Collection<String> values) {
        if (RuleIndex.isNotEmpty(values)) {
            BoolQueryBuilder valuesFilter = QueryBuilders.boolQuery();
            for (String value : values) {
                TermQueryBuilder valueFilter = QueryBuilders.termQuery((String)field, (String)value);
                valuesFilter.should((QueryBuilder)valueFilter);
            }
            filter.must((QueryBuilder)valuesFilter);
        }
        return filter;
    }

    private static BoolQueryBuilder addTermFilter(BoolQueryBuilder filter, String field, @Nullable String value) {
        if (StringUtils.isNotEmpty((String)value)) {
            filter.must((QueryBuilder)QueryBuilders.termQuery((String)field, (String)value));
        }
        return filter;
    }

    private static Map<String, AggregationBuilder> getFacets(RuleQuery query, SearchOptions options, QueryBuilder queryBuilder, Map<String, QueryBuilder> filters) {
        HashMap<String, AggregationBuilder> aggregations = new HashMap<String, AggregationBuilder>();
        StickyFacetBuilder stickyFacetBuilder = RuleIndex.stickyFacetBuilder(queryBuilder, filters);
        RuleIndex.addDefaultFacets(query, options, aggregations, stickyFacetBuilder);
        RuleIndex.addStatusFacetIfNeeded(options, aggregations, stickyFacetBuilder);
        if (options.getFacets().contains(FACET_SEVERITIES)) {
            aggregations.put(FACET_SEVERITIES, stickyFacetBuilder.buildStickyFacet("severity", FACET_SEVERITIES, Severity.ALL.toArray()));
        }
        RuleIndex.addActiveSeverityFacetIfNeeded(query, options, aggregations, stickyFacetBuilder);
        return aggregations;
    }

    private static void addDefaultFacets(RuleQuery query, SearchOptions options, Map<String, AggregationBuilder> aggregations, StickyFacetBuilder stickyFacetBuilder) {
        if (options.getFacets().contains(FACET_LANGUAGES) || options.getFacets().contains(FACET_OLD_DEFAULT)) {
            Collection<String> languages = query.getLanguages();
            aggregations.put(FACET_LANGUAGES, stickyFacetBuilder.buildStickyFacet("lang", FACET_LANGUAGES, 100, languages == null ? new String[]{} : languages.toArray()));
        }
        if (options.getFacets().contains(FACET_TAGS) || options.getFacets().contains(FACET_OLD_DEFAULT)) {
            Collection<String> tags = query.getTags();
            Preconditions.checkArgument((query.getOrganization() != null ? 1 : 0) != 0, (String)"Cannot use tags facet, if no organization is specified.", (Object[])new Object[]{query.getTags()});
            Function<TermsAggregationBuilder, AggregationBuilder> childFeature = termsAggregation -> {
                FilterAggregationBuilder scopeAggregation = (FilterAggregationBuilder)AggregationBuilders.filter((String)"scope_filter_for_tags", (QueryBuilder)QueryBuilders.termsQuery((String)"ruleExt_scope", (String[])new String[]{RuleExtensionScope.system().getScope(), RuleExtensionScope.organization(query.getOrganization()).getScope()})).subAggregation((AggregationBuilder)termsAggregation);
                return JoinAggregationBuilders.children((String)("children_for_" + termsAggregation.getName()), (String)RuleIndexDefinition.TYPE_RULE_EXTENSION.getName()).subAggregation((AggregationBuilder)scopeAggregation);
            };
            aggregations.put(FACET_TAGS, stickyFacetBuilder.buildStickyFacet("ruleExt_tags", FACET_TAGS, 100, childFeature, tags == null ? new String[]{} : tags.toArray()));
        }
        if (options.getFacets().contains(FACET_TYPES)) {
            Collection<RuleType> types = query.getTypes();
            aggregations.put(FACET_TYPES, stickyFacetBuilder.buildStickyFacet("type", FACET_TYPES, types == null ? new String[]{} : types.toArray()));
        }
        if (options.getFacets().contains(FACET_REPOSITORIES) || options.getFacets().contains(FACET_OLD_DEFAULT)) {
            Collection<String> repositories = query.getRepositories();
            aggregations.put(FACET_REPOSITORIES, stickyFacetBuilder.buildStickyFacet("repo", FACET_REPOSITORIES, repositories == null ? new String[]{} : repositories.toArray()));
        }
    }

    private static void addStatusFacetIfNeeded(SearchOptions options, Map<String, AggregationBuilder> aggregations, StickyFacetBuilder stickyFacetBuilder) {
        if (options.getFacets().contains(FACET_STATUSES)) {
            BoolQueryBuilder facetFilter = stickyFacetBuilder.getStickyFacetFilter("status");
            AbstractAggregationBuilder statuses = AggregationBuilders.filter((String)"statuses_filter", (QueryBuilder)facetFilter).subAggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)FACET_STATUSES).field("status")).includeExclude(new IncludeExclude(Joiner.on((char)'|').join(ALL_STATUSES_EXCEPT_REMOVED), RuleStatus.REMOVED.toString())).size(ALL_STATUSES_EXCEPT_REMOVED.size()));
            aggregations.put(FACET_STATUSES, (AggregationBuilder)AggregationBuilders.global((String)FACET_STATUSES).subAggregation((AggregationBuilder)statuses));
        }
    }

    private static void addActiveSeverityFacetIfNeeded(RuleQuery query, SearchOptions options, Map<String, AggregationBuilder> aggregations, StickyFacetBuilder stickyFacetBuilder) {
        QProfileDto profile = query.getQProfile();
        if (options.getFacets().contains(FACET_ACTIVE_SEVERITIES) && profile != null) {
            HasParentQueryBuilder ruleFilter = JoinQueryBuilders.hasParentQuery((String)RuleIndexDefinition.TYPE_RULE.getType(), (QueryBuilder)stickyFacetBuilder.getStickyFacetFilter("activation"), (boolean)false);
            BoolQueryBuilder childrenFilter = QueryBuilders.boolQuery();
            RuleIndex.addTermFilter(childrenFilter, "activeRule_ruleProfile", profile.getRulesProfileUuid());
            RuleIndex.addTermFilter(childrenFilter, "activeRule_inheritance", query.getInheritance());
            BoolQueryBuilder activeRuleFilter = childrenFilter.must((QueryBuilder)ruleFilter);
            AbstractAggregationBuilder activeSeverities = JoinAggregationBuilders.children((String)"active_severities_children", (String)RuleIndexDefinition.TYPE_ACTIVE_RULE.getName()).subAggregation((AggregationBuilder)AggregationBuilders.filter((String)"active_severities_filter", (QueryBuilder)activeRuleFilter).subAggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)FACET_ACTIVE_SEVERITIES).field("activeRule_severity")).includeExclude(new IncludeExclude(Joiner.on((char)'|').join((Iterable)Severity.ALL), null)).size(Severity.ALL.size())));
            aggregations.put(FACET_ACTIVE_SEVERITIES, (AggregationBuilder)AggregationBuilders.global((String)FACET_ACTIVE_SEVERITIES).subAggregation((AggregationBuilder)activeSeverities));
        }
    }

    private static StickyFacetBuilder stickyFacetBuilder(QueryBuilder query, Map<String, QueryBuilder> filters) {
        return new StickyFacetBuilder(query, filters, null, BucketOrder.compound((BucketOrder[])new BucketOrder[]{BucketOrder.count((boolean)false), BucketOrder.key((boolean)true)}));
    }

    private static void setSorting(RuleQuery query, SearchRequestBuilder esSearch) {
        String queryText = query.getQueryText();
        if (query.getSortField() != null) {
            FieldSortBuilder sort = SortBuilders.fieldSort((String)RuleIndex.appendSortSuffixIfNeeded(query.getSortField()));
            if (query.isAscendingSort()) {
                sort.order(SortOrder.ASC);
            } else {
                sort.order(SortOrder.DESC);
            }
            esSearch.addSort((SortBuilder)sort);
        } else if (StringUtils.isNotEmpty((String)queryText)) {
            esSearch.addSort((SortBuilder)SortBuilders.scoreSort());
        } else {
            esSearch.addSort(RuleIndex.appendSortSuffixIfNeeded("updatedAt"), SortOrder.DESC);
            esSearch.addSort(RuleIndex.appendSortSuffixIfNeeded("key"), SortOrder.ASC);
        }
    }

    private static String appendSortSuffixIfNeeded(String field) {
        return field + (field.equals("name") || field.equals("key") ? "." + DefaultIndexSettingsElement.SORTABLE_ANALYZER.getSubFieldSuffix() : "");
    }

    private static void setPagination(SearchOptions options, SearchRequestBuilder esSearch) {
        esSearch.setFrom(options.getOffset());
        esSearch.setSize(options.getLimit());
    }

    public List<String> listTags(@Nullable OrganizationDto organization, @Nullable String query, int size) {
        int maxPageSize = 500;
        Preconditions.checkArgument((size <= maxPageSize ? 1 : 0) != 0, (Object)("Page size must be lower than or equals to " + maxPageSize));
        if (size <= 0) {
            return Collections.emptyList();
        }
        ImmutableList.Builder scopes = ImmutableList.builder().add((Object)RuleExtensionScope.system().getScope());
        if (organization != null) {
            scopes.add((Object)RuleExtensionScope.organization(organization).getScope());
        }
        TermsQueryBuilder scopeFilter = QueryBuilders.termsQuery((String)"ruleExt_scope", (String[])((String[])scopes.build().toArray((Object[])new String[0])));
        TermsAggregationBuilder termsAggregation = ((TermsAggregationBuilder)AggregationBuilders.terms((String)AGGREGATION_NAME_FOR_TAGS).field("ruleExt_tags")).size(size).order(BucketOrder.key((boolean)true)).minDocCount(1L);
        Optional.ofNullable(query).map(EsUtils::escapeSpecialRegexChars).map(queryString -> ".*" + queryString + ".*").map(s -> new IncludeExclude(s, null)).ifPresent(arg_0 -> ((TermsAggregationBuilder)termsAggregation).includeExclude(arg_0));
        SearchRequestBuilder request = this.client.prepareSearch(RuleIndexDefinition.TYPE_RULE_EXTENSION.getMainType()).setQuery((QueryBuilder)QueryBuilders.boolQuery().filter((QueryBuilder)scopeFilter)).setSize(0).addAggregation((AggregationBuilder)termsAggregation);
        SearchResponse esResponse = (SearchResponse)request.get();
        return EsUtils.termsKeys((Terms)esResponse.getAggregations().get(AGGREGATION_NAME_FOR_TAGS));
    }

    private static boolean isNotEmpty(@Nullable Collection list) {
        return list != null && !list.isEmpty();
    }
}

