/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.util;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.sonar.api.utils.log.Loggers;
import org.sonar.server.util.StoppableExecutorService;

public abstract class AbstractStoppableExecutorService<D extends ExecutorService>
implements StoppableExecutorService {
    protected final D delegate;

    public AbstractStoppableExecutorService(D delegate) {
        this.delegate = delegate;
    }

    @Override
    public void stop() {
        this.delegate.shutdown();
        try {
            if (!this.delegate.awaitTermination(5L, TimeUnit.SECONDS)) {
                this.delegate.shutdownNow();
                if (!this.delegate.awaitTermination(5L, TimeUnit.SECONDS)) {
                    Loggers.get(this.getClass()).warn(String.format("Pool %s did not terminate", this.getClass().getSimpleName()));
                }
            }
        }
        catch (InterruptedException ie) {
            Loggers.get(this.getClass()).warn(String.format("Termination of pool %s failed", this.getClass().getSimpleName()), (Throwable)ie);
            this.delegate.shutdownNow();
        }
    }

    @Override
    public void shutdown() {
        this.delegate.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.delegate.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.delegate.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.delegate.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.delegate.awaitTermination(timeout, unit);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return this.delegate.submit(task);
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        return this.delegate.submit(task, result);
    }

    @Override
    public Future<?> submit(Runnable task) {
        return this.delegate.submit(task);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.delegate.invokeAll(tasks);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return this.delegate.invokeAll(tasks, timeout, unit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return this.delegate.invokeAny(tasks);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.delegate.invokeAny(tasks, timeout, unit);
    }

    @Override
    public void execute(Runnable command) {
        this.delegate.execute(command);
    }
}

