/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.dotnet.shared.plugins;

import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import org.sonar.api.batch.ScannerSide;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonarsource.dotnet.shared.plugins.AbstractConfiguration;
import org.sonarsource.dotnet.shared.plugins.DotNetPluginMetadata;
import org.sonarsource.dotnet.shared.plugins.ReportPathCollector;
import org.sonarsource.dotnet.shared.plugins.RoslynReport;

@ScannerSide
public class PropertiesSensor
implements Sensor {
    private final AbstractConfiguration configuration;
    private final ReportPathCollector reportPathCollector;
    private final DotNetPluginMetadata pluginMetadata;

    public PropertiesSensor(AbstractConfiguration configuration, ReportPathCollector reportPathCollector, DotNetPluginMetadata pluginMetadata) {
        this.configuration = configuration;
        this.reportPathCollector = reportPathCollector;
        this.pluginMetadata = pluginMetadata;
    }

    public void describe(SensorDescriptor descriptor) {
        descriptor.name(this.pluginMetadata.shortLanguageName() + " Properties").onlyOnLanguage(this.pluginMetadata.languageKey());
    }

    public void execute(SensorContext context) {
        List<Path> roslynReportPaths;
        List<Path> protobufReportPaths = this.configuration.protobufReportPaths();
        if (!protobufReportPaths.isEmpty()) {
            this.reportPathCollector.addProtobufDirs(protobufReportPaths);
        }
        if (!(roslynReportPaths = this.configuration.roslynReportPaths()).isEmpty()) {
            this.reportPathCollector.addRoslynDirs(roslynReportPaths.stream().map(path -> new RoslynReport(context.module(), (Path)path)).collect(Collectors.toList()));
        }
    }
}

