/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.xml.checks;

import java.util.Collections;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.plugins.xml.Utils;
import org.sonarsource.analyzer.commons.xml.XmlFile;
import org.sonarsource.analyzer.commons.xml.XmlTextRange;
import org.sonarsource.analyzer.commons.xml.checks.SonarXmlCheck;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Rule(key="IndentCheck")
public class IndentationCheck
extends SonarXmlCheck {
    public static final String RULE_KEY = "IndentCheck";
    private static final String MESSAGE = "Make this element start at column %s.";
    @RuleProperty(key="indentSize", description="Number of white-spaces of an indent. If this property is not set, we just check that the code is indented.", defaultValue="2", type="INTEGER")
    private int indentSize = 2;
    @RuleProperty(key="tabSize", description="Equivalent number of spaces of a tabulation", defaultValue="2", type="INTEGER")
    private int tabSize = 2;

    @Override
    public void scanFile(XmlFile file) {
        this.validateIndent(file.getDocument());
    }

    public void setIndentSize(int indentSize) {
        this.indentSize = indentSize;
    }

    public void setTabSize(int tabSize) {
        this.tabSize = tabSize;
    }

    private boolean validateIndent(Node node) {
        if (node.getNodeType() == 1 && this.checkIndentation((Element)node)) {
            return true;
        }
        boolean issueOnLine = false;
        block4: for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            switch (child.getNodeType()) {
                case 1: {
                    if (issueOnLine) continue block4;
                    issueOnLine = this.validateIndent(child);
                    continue block4;
                }
                case 3: {
                    if (!child.getTextContent().contains("\n")) continue block4;
                    issueOnLine = false;
                    continue block4;
                }
            }
        }
        if (node.getNodeType() == 1) {
            this.checkClosingTag((Element)node);
        }
        return false;
    }

    private boolean checkIndentation(Element element) {
        if (!IndentationCheck.needToCheckIndentation(element)) {
            return false;
        }
        int expectedIndent = IndentationCheck.depth(element) * this.indentSize;
        if (expectedIndent != this.startIndent(element.getPreviousSibling())) {
            this.reportIssue(XmlFile.startLocation(element), expectedIndent);
            return true;
        }
        return false;
    }

    private void reportIssue(XmlTextRange textRange, int expectedIndent) {
        this.reportIssue(textRange, String.format(MESSAGE, expectedIndent + 1), Collections.emptyList());
    }

    private static int depth(Node node) {
        int depth = 0;
        Node parent = node.getParentNode();
        while (parent.getParentNode() != null) {
            ++depth;
            parent = parent.getParentNode();
        }
        return depth;
    }

    private int startIndent(Node node) {
        int indent = 0;
        for (Node sibling = node; sibling != null; sibling = sibling.getPreviousSibling()) {
            short nodeType = sibling.getNodeType();
            if (nodeType == 8 || nodeType == 1) {
                return indent;
            }
            if (nodeType != 3) continue;
            String text = sibling.getTextContent();
            block6: for (int i = text.length() - 1; i >= 0; --i) {
                char c = text.charAt(i);
                switch (c) {
                    case '\n': {
                        return indent;
                    }
                    case '\t': {
                        indent += this.tabSize;
                        continue block6;
                    }
                    case ' ': {
                        ++indent;
                        continue block6;
                    }
                    default: {
                        return indent;
                    }
                }
            }
        }
        return indent;
    }

    private void checkClosingTag(Element element) {
        if (Utils.isSelfClosing(element)) {
            return;
        }
        XmlTextRange startLocation = XmlFile.startLocation(element);
        XmlTextRange endLocation = XmlFile.endLocation(element);
        if (startLocation.getEndLine() != endLocation.getStartLine()) {
            int endIndent;
            if (!IndentationCheck.needToCheckIndentation(element)) {
                return;
            }
            int startIndent = this.startIndent(element.getPreviousSibling());
            if (startIndent != (endIndent = this.startIndent(element.getLastChild()))) {
                this.reportIssue(endLocation, startIndent);
            }
        }
    }

    private static boolean needToCheckIndentation(Element element) {
        if (element.getChildNodes().getLength() > 1) {
            return true;
        }
        Node previous = element.getPreviousSibling();
        if (IndentationCheck.isNonEmptyTextNode(previous)) {
            return false;
        }
        Node next = element.getNextSibling();
        if (IndentationCheck.isNonEmptyTextNode(next)) {
            return false;
        }
        for (Node parent = element.getParentNode(); parent != null && parent.getChildNodes().getLength() == 1; parent = parent.getParentNode()) {
            short parentType = parent.getNodeType();
            if (parentType != 1 || !IndentationCheck.isNonEmptyTextNode(parent.getPreviousSibling())) continue;
            return false;
        }
        return true;
    }

    private static boolean isNonEmptyTextNode(@Nullable Node node) {
        return node != null && node.getNodeType() == 3 && !node.getTextContent().trim().isEmpty();
    }
}

