/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.xml.checks;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonarsource.analyzer.commons.xml.XmlFile;
import org.sonarsource.analyzer.commons.xml.XmlTextRange;
import org.sonarsource.analyzer.commons.xml.checks.SonarXmlCheck;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Rule(key="NewlineCheck")
public class NewlineCheck
extends SonarXmlCheck {
    public static final String RULE_KEY = "NewlineCheck";
    private static final String MESSAGE_START = "Put this element on a separate line.";
    private static final String MESSAGE_END = "Add a newline after this tag.";

    @Override
    public void scanFile(XmlFile file) {
        this.visitNode(file.getDocument());
    }

    private void visitNode(Node node) {
        List<Node> children = XmlFile.children(node);
        if (node.getNodeType() == 1) {
            Element currentElement = (Element)node;
            this.checkChildrenLine(children, currentElement);
            this.checkNextSiblingLine(currentElement);
        }
        children.forEach(this::visitNode);
    }

    private void checkChildrenLine(List<Node> children, Element currentElement) {
        NewlineCheck.getOutermostChildElements(children).ifPresent(outermostChildElements -> {
            boolean singleLineChildElement;
            XmlTextRange start = XmlFile.startLocation(currentElement);
            XmlTextRange end = XmlFile.endLocation(currentElement);
            XmlTextRange firstChildElementStart = XmlFile.startLocation(outermostChildElements.first);
            XmlTextRange lastChildElementEnd = XmlFile.endLocation(outermostChildElements.last);
            boolean firstChildBadlyFormatted = firstChildElementStart.getStartLine() == start.getEndLine();
            boolean lastChildBadlyFormatted = lastChildElementEnd.getEndLine() == end.getStartLine();
            boolean singleChildElement = outermostChildElements.last.equals(outermostChildElements.first);
            boolean bl = singleLineChildElement = firstChildElementStart.getStartLine() == lastChildElementEnd.getEndLine();
            if (singleChildElement && singleLineChildElement && firstChildBadlyFormatted && lastChildBadlyFormatted) {
                this.reportIssue(outermostChildElements.first, MESSAGE_START);
            } else {
                if (firstChildBadlyFormatted) {
                    this.reportIssue(firstChildElementStart, MESSAGE_START, Collections.emptyList());
                }
                if (lastChildBadlyFormatted) {
                    this.reportIssue(lastChildElementEnd, MESSAGE_END, Collections.emptyList());
                }
            }
        });
    }

    private void checkNextSiblingLine(Element node) {
        XmlTextRange nextSiblingElementStart;
        XmlTextRange end = XmlFile.endLocation(node);
        Element nextSiblingElement = NewlineCheck.getNextSiblingElement(node);
        if (nextSiblingElement != null && (nextSiblingElementStart = XmlFile.startLocation(nextSiblingElement)).getStartLine() == end.getEndLine()) {
            this.reportIssue(nextSiblingElementStart, MESSAGE_START, Collections.emptyList());
        }
    }

    @Nullable
    private static Element getNextSiblingElement(Node node) {
        Node nextSibling = node.getNextSibling();
        if (nextSibling == null) {
            return null;
        }
        if (nextSibling.getNodeType() == 1) {
            return (Element)nextSibling;
        }
        return NewlineCheck.getNextSiblingElement(nextSibling);
    }

    private static Optional<OutermostChildElements> getOutermostChildElements(List<Node> children) {
        Element firstChildElement = null;
        Element lastChildElement = null;
        for (Node child : children) {
            if (child.getNodeType() != 1) continue;
            if (firstChildElement == null) {
                firstChildElement = (Element)child;
            }
            lastChildElement = (Element)child;
        }
        if (firstChildElement != null) {
            return Optional.of(new OutermostChildElements(firstChildElement, lastChildElement));
        }
        return Optional.empty();
    }

    private static class OutermostChildElements {
        Element first = null;
        Element last = null;

        OutermostChildElements(Element first, Element last) {
            this.first = first;
            this.last = last;
        }
    }
}

