/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.analyzer.commons;

import java.util.Iterator;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;

public class ProgressReport
implements Runnable {
    private final long period;
    private final Logger logger;
    private int count;
    private int currentFileNumber = -1;
    private String currentFilename;
    private Iterator<String> it;
    private final Thread thread;
    private final String adjective;
    private boolean success = false;

    public ProgressReport(String threadName, long period, Logger logger, String adjective) {
        this.period = period;
        this.logger = logger;
        this.adjective = adjective;
        this.thread = new Thread(this);
        this.thread.setName(threadName);
        this.thread.setDaemon(true);
    }

    public ProgressReport(String threadName, long period, String adjective) {
        this(threadName, period, Loggers.get(ProgressReport.class), adjective);
    }

    public ProgressReport(String threadName, long period) {
        this(threadName, period, "analyzed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ProgressReport progressReport;
        while (!Thread.interrupted()) {
            try {
                Thread.sleep(this.period);
                progressReport = this;
                synchronized (progressReport) {
                    this.log(this.currentFileNumber + "/" + this.count + " files " + this.adjective + ", current file: " + this.currentFilename);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
        }
        progressReport = this;
        synchronized (progressReport) {
            if (this.success) {
                this.log(this.count + "/" + this.count + " source files have been " + this.adjective);
            }
        }
    }

    public synchronized void start(Iterable<String> filenames) {
        this.count = ProgressReport.size(filenames);
        this.it = filenames.iterator();
        this.nextFile();
        this.log(this.count + " source files to be " + this.adjective);
        this.thread.start();
    }

    public synchronized void nextFile() {
        if (this.it.hasNext()) {
            ++this.currentFileNumber;
            this.currentFilename = this.it.next();
        }
    }

    public synchronized void stop() {
        this.success = true;
        this.thread.interrupt();
    }

    public synchronized void cancel() {
        this.thread.interrupt();
    }

    public void join() throws InterruptedException {
        this.thread.join();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void log(String message) {
        Logger logger = this.logger;
        synchronized (logger) {
            this.logger.info(message);
            this.logger.notifyAll();
        }
    }

    private static int size(Iterable iterable) {
        int count = 0;
        Iterator iterator = iterable.iterator();
        while (iterator.hasNext()) {
            iterator.next();
            ++count;
        }
        return count;
    }
}

