/*
 * Decompiled with CFR 0.152.
 */
package org.joni.ast;

import org.joni.ScanEnvironment;
import org.joni.ast.StateNode;
import org.joni.exception.ValueException;

public final class BackRefNode
extends StateNode {
    public final int[] back;
    public int backNum;
    public int nestLevel;

    private BackRefNode(int backNum, int[] backRefs, boolean byName, ScanEnvironment env) {
        super(4);
        this.backNum = backNum;
        if (byName) {
            this.setNameRef();
        }
        for (int i2 = 0; i2 < backNum; ++i2) {
            if (backRefs[i2] > env.numMem || env.memNodes[backRefs[i2]] != null) continue;
            this.setRecursion();
            break;
        }
        this.back = backRefs;
    }

    public BackRefNode(int backNum, int[] backRefs, boolean byName, boolean existLevel, int nestLevel, ScanEnvironment env) {
        this(backNum, backRefs, byName, env);
        if (existLevel) {
            this.setNestLevel();
            this.nestLevel = nestLevel;
        }
    }

    public void renumber(int[] map2) {
        if (!this.isNameRef()) {
            throw new ValueException("numbered backref/call is not allowed. (use name)");
        }
        int oldNum = this.backNum;
        int pos2 = 0;
        for (int i2 = 0; i2 < oldNum; ++i2) {
            int n = map2[this.back[i2]];
            if (n <= 0) continue;
            this.back[pos2] = n;
            ++pos2;
        }
        this.backNum = pos2;
    }

    public String getName() {
        return "Back Ref";
    }

    public String toString(int level2) {
        StringBuilder sb = new StringBuilder(super.toString(level2));
        sb.append("\n  backNum: " + this.backNum);
        String backs = "";
        for (int i2 = 0; i2 < this.back.length; ++i2) {
            backs = backs + this.back[i2] + ", ";
        }
        sb.append("\n  back: " + backs);
        sb.append("\n  nextLevel: " + this.nestLevel);
        return sb.toString();
    }
}

