/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.ruby.converter.adapter;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubySymbol;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.specialized.RubyArrayTwoObject;
import org.sonarsource.ruby.converter.adapter.JRubyObjectAdapter;
import org.sonarsource.ruby.converter.adapter.RangeAdapter;
import org.sonarsource.slang.api.Token;
import org.sonarsource.slang.impl.TokenImpl;

public class TokenAdapter
extends JRubyObjectAdapter<RubyArrayTwoObject> {
    private static final Set<String> RUBY_STRING_TOKENS = Stream.of("tSTRING", "tSTRING_BEG", "tSTRING_CONTENT", "tSTRING_END").collect(Collectors.toSet());

    public TokenAdapter(Ruby runtime2, RubyArrayTwoObject underlyingRubyObject) {
        super(runtime2, underlyingRubyObject);
    }

    public RubySymbol getTokenType() {
        return (RubySymbol)((RubyArrayTwoObject)this.underlyingRubyObject).eltInternal(0);
    }

    @Nullable
    public String getText() {
        Object textElement = ((RubyArray)((RubyArrayTwoObject)this.underlyingRubyObject).eltInternal(1)).get(0);
        if (textElement != null) {
            return textElement.toString();
        }
        return null;
    }

    public RangeAdapter getRange() {
        return new RangeAdapter(this.runtime, (IRubyObject)((RubyArray)((RubyArrayTwoObject)this.underlyingRubyObject).eltInternal(1)).get(1));
    }

    @Nullable
    public Token toSlangToken() {
        Token.Type type2 = Token.Type.OTHER;
        RubySymbol tokenType = this.getTokenType();
        String tokenString = tokenType.asJavaString();
        if (tokenString != null && tokenString.startsWith("k")) {
            type2 = Token.Type.KEYWORD;
        } else if (RUBY_STRING_TOKENS.contains(tokenString)) {
            type2 = Token.Type.STRING_LITERAL;
        }
        String text = this.getText();
        if (text == null || text.length() == 0 && type2 != Token.Type.STRING_LITERAL) {
            return null;
        }
        return new TokenImpl(this.getRange().toTextRange(), this.getText(), type2);
    }
}

