/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.slang.checks;

import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonarsource.slang.api.ExceptionHandlingTree;
import org.sonarsource.slang.api.HasTextRange;
import org.sonarsource.slang.api.IfTree;
import org.sonarsource.slang.api.LoopTree;
import org.sonarsource.slang.api.MatchTree;
import org.sonarsource.slang.api.Token;
import org.sonarsource.slang.api.Tree;
import org.sonarsource.slang.checks.api.CheckContext;
import org.sonarsource.slang.checks.api.InitContext;
import org.sonarsource.slang.checks.api.SecondaryLocation;
import org.sonarsource.slang.checks.api.SlangCheck;
import org.sonarsource.slang.checks.utils.ExpressionUtils;

@Rule(key="S134")
public class TooDeeplyNestedStatementsCheck
implements SlangCheck {
    private static final int DEFAULT_MAX_DEPTH = 3;
    @RuleProperty(key="max", description="Maximum allowed control flow statement nesting depth", defaultValue="3")
    public int max = 3;

    @Override
    public void initialize(InitContext init) {
        init.register(IfTree.class, this::checkNestedDepth);
        init.register(LoopTree.class, this::checkNestedDepth);
        init.register(MatchTree.class, this::checkNestedDepth);
        init.register(ExceptionHandlingTree.class, this::checkNestedDepth);
    }

    private void checkNestedDepth(CheckContext ctx, Tree tree) {
        if (TooDeeplyNestedStatementsCheck.isElseIfStatement(ctx.parent(), tree)) {
            return;
        }
        if (ExpressionUtils.isTernaryOperator(ctx.ancestors(), tree)) {
            return;
        }
        Iterator<Tree> iterator = ctx.ancestors().iterator();
        LinkedList<Token> nestedParentNodes = new LinkedList<Token>();
        Tree last2 = tree;
        while (iterator.hasNext()) {
            Tree parent = iterator.next();
            if (TooDeeplyNestedStatementsCheck.isElseIfStatement(parent, last2) && !nestedParentNodes.isEmpty()) {
                nestedParentNodes.removeLast();
            }
            if (parent instanceof LoopTree || parent instanceof ExceptionHandlingTree || parent instanceof IfTree || parent instanceof MatchTree) {
                nestedParentNodes.addLast(TooDeeplyNestedStatementsCheck.getNodeToHighlight(parent));
            }
            if (nestedParentNodes.size() > this.max) {
                return;
            }
            last2 = parent;
        }
        if (nestedParentNodes.size() == this.max) {
            this.reportIssue(ctx, tree, nestedParentNodes);
        }
    }

    private static boolean isElseIfStatement(@Nullable Tree parent, @Nullable Tree tree) {
        return tree instanceof IfTree && parent instanceof IfTree && tree.equals(((IfTree)parent).elseBranch());
    }

    private void reportIssue(CheckContext ctx, Tree statement, Deque<Token> nestedStatements) {
        String message2 = String.format("Refactor this code to not nest more than %s control flow statements.", this.max);
        ArrayList<SecondaryLocation> secondaryLocations = new ArrayList<SecondaryLocation>(nestedStatements.size());
        int nestedDepth = 0;
        while (!nestedStatements.isEmpty()) {
            String secondaryLocationMessage = String.format("Nesting depth %s", ++nestedDepth);
            secondaryLocations.add(new SecondaryLocation(nestedStatements.removeLast().textRange(), secondaryLocationMessage));
        }
        Token nodeToHighlight = TooDeeplyNestedStatementsCheck.getNodeToHighlight(statement);
        ctx.reportIssue((HasTextRange)nodeToHighlight, message2, secondaryLocations);
    }

    private static Token getNodeToHighlight(Tree tree) {
        if (tree instanceof IfTree) {
            return ((IfTree)tree).ifKeyword();
        }
        if (tree instanceof MatchTree) {
            return ((MatchTree)tree).keyword();
        }
        if (tree instanceof ExceptionHandlingTree) {
            return ((ExceptionHandlingTree)tree).tryKeyword();
        }
        return ((LoopTree)tree).keyword();
    }
}

