/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.slang.checks;

import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonarsource.slang.api.FunctionDeclarationTree;
import org.sonarsource.slang.api.HasTextRange;
import org.sonarsource.slang.api.VariableDeclarationTree;
import org.sonarsource.slang.checks.api.InitContext;
import org.sonarsource.slang.checks.api.SlangCheck;
import org.sonarsource.slang.utils.SyntacticEquivalence;

@Rule(key="S1481")
public class UnusedLocalVariableCheck
implements SlangCheck {
    @Override
    public void initialize(InitContext init) {
        init.register(FunctionDeclarationTree.class, (ctx, functionDeclarationTree) -> {
            if (ctx.ancestors().stream().anyMatch(tree -> tree instanceof FunctionDeclarationTree)) {
                return;
            }
            Set variableIdentifiers = functionDeclarationTree.descendants().filter(tree -> tree instanceof VariableDeclarationTree).map(VariableDeclarationTree.class::cast).map(VariableDeclarationTree::identifier).collect(Collectors.toSet());
            Set identifierTrees = functionDeclarationTree.descendants().filter(tree -> !variableIdentifiers.contains(tree)).collect(Collectors.toSet());
            variableIdentifiers.stream().filter(var -> identifierTrees.stream().noneMatch(identifier -> SyntacticEquivalence.areEquivalent(var, identifier))).forEach(identifier -> ctx.reportIssue((HasTextRange)identifier, "Remove this unused \"" + identifier.name() + "\" local variable."));
        });
    }
}

