/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.slang.checks;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonarsource.slang.api.ClassDeclarationTree;
import org.sonarsource.slang.api.FunctionDeclarationTree;
import org.sonarsource.slang.api.IdentifierTree;
import org.sonarsource.slang.checks.api.InitContext;
import org.sonarsource.slang.checks.api.SlangCheck;
import org.sonarsource.slang.checks.utils.FunctionUtils;
import org.sonarsource.slang.utils.SyntacticEquivalence;

@Rule(key="S1144")
public class UnusedPrivateMethodCheck
implements SlangCheck {
    private static final Set<String> IGNORED_METHODS = new HashSet<String>(Arrays.asList("writeObject", "readObject", "writeReplace", "readResolve", "readObjectNoData"));

    @Override
    public void initialize(InitContext init) {
        init.register(ClassDeclarationTree.class, (ctx, classDeclarationTree) -> {
            if (ctx.ancestors().stream().anyMatch(ClassDeclarationTree.class::isInstance)) {
                return;
            }
            HashSet methods2 = new HashSet();
            HashSet usedIdentifiers = new HashSet();
            classDeclarationTree.descendants().forEach(tree -> {
                if (tree instanceof FunctionDeclarationTree && !((FunctionDeclarationTree)tree).isConstructor()) {
                    methods2.add((FunctionDeclarationTree)tree);
                } else if (tree instanceof IdentifierTree) {
                    usedIdentifiers.add((IdentifierTree)tree);
                }
            });
            usedIdentifiers.removeAll(methods2.stream().map(FunctionDeclarationTree::name).collect(Collectors.toSet()));
            Set usedUniqueIdentifiers = usedIdentifiers.stream().filter(Objects::nonNull).map(SyntacticEquivalence::getUniqueIdentifier).collect(Collectors.toCollection(HashSet::new));
            methods2.stream().filter(UnusedPrivateMethodCheck::isValidPrivateMethod).forEach(tree -> {
                IdentifierTree identifier = tree.name();
                if (UnusedPrivateMethodCheck.isUnusedMethod(identifier, usedUniqueIdentifiers) && !IGNORED_METHODS.contains(identifier.name())) {
                    String message2 = String.format("Remove this unused private \"%s\" method.", identifier.name());
                    ctx.reportIssue(tree.rangeToHighlight(), message2);
                }
            });
        });
    }

    private static boolean isValidPrivateMethod(FunctionDeclarationTree method2) {
        return FunctionUtils.isPrivateMethod(method2) && !FunctionUtils.isOverrideMethod(method2);
    }

    private static boolean isUnusedMethod(@Nullable IdentifierTree identifier, Set<String> usedIdentifierNames) {
        return identifier != null && !usedIdentifierNames.contains(SyntacticEquivalence.getUniqueIdentifier(identifier));
    }
}

