/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.ce.measure.test;

import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.sonar.api.ce.measure.Component;

@Immutable
public class TestComponent
implements Component {
    private final String key;
    private final Component.Type type;
    @CheckForNull
    private final Component.FileAttributes fileAttributes;

    public TestComponent(String key, Component.Type type, @Nullable Component.FileAttributes fileAttributes) {
        this.key = Objects.requireNonNull(key, "Key cannot be null");
        this.type = Objects.requireNonNull(type, "Type cannot be null");
        this.fileAttributes = this.checkFileAttributes(fileAttributes);
    }

    @CheckForNull
    private Component.FileAttributes checkFileAttributes(@Nullable Component.FileAttributes fileAttributes) {
        if (fileAttributes == null && this.type == Component.Type.FILE) {
            throw new IllegalArgumentException("Component of type FILE must have a FileAttributes object");
        }
        if (fileAttributes != null && this.type != Component.Type.FILE) {
            throw new IllegalArgumentException("Only component of type FILE have a FileAttributes object");
        }
        return fileAttributes;
    }

    @Override
    public Component.Type getType() {
        return this.type;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public Component.FileAttributes getFileAttributes() {
        Preconditions.checkState((this.type == Component.Type.FILE ? 1 : 0) != 0, (Object)"Only component of type FILE have a FileAttributes object");
        return this.fileAttributes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TestComponent component = (TestComponent)o;
        return this.key.equals(component.key);
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public String toString() {
        return "ComponentImpl{key=" + this.key + ", type='" + (Object)((Object)this.type) + '\'' + ", fileAttributes=" + this.fileAttributes + '}';
    }

    @Immutable
    public static class FileAttributesImpl
    implements Component.FileAttributes {
        private final boolean unitTest;
        private final String languageKey;

        public FileAttributesImpl(@Nullable String languageKey, boolean unitTest) {
            this.languageKey = languageKey;
            this.unitTest = unitTest;
        }

        @Override
        public boolean isUnitTest() {
            return this.unitTest;
        }

        @Override
        @CheckForNull
        public String getLanguageKey() {
            return this.languageKey;
        }

        public String toString() {
            return "FileAttributesImpl{languageKey='" + this.languageKey + '\'' + ", unitTest=" + this.unitTest + '}';
        }
    }
}

