/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.config.internal;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.lang.ArrayUtils;

public class MultivalueProperty {
    private MultivalueProperty() {
    }

    public static String[] parseAsCsv(String key, String value) {
        return MultivalueProperty.parseAsCsv(key, value, Function.identity());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String[] parseAsCsv(String key, String value, Function<String, String> valueProcessor) {
        String cleanValue = MultivalueProperty.trimFieldsAndRemoveEmptyFields(value);
        ArrayList<String> result = new ArrayList<String>();
        try (CSVParser csvParser = CSVFormat.RFC4180.withHeader(new String[]{null}).withIgnoreEmptyLines().withIgnoreSurroundingSpaces().parse((Reader)new StringReader(cleanValue));){
            List records = csvParser.getRecords();
            if (records.isEmpty()) {
                String[] stringArray = ArrayUtils.EMPTY_STRING_ARRAY;
                return stringArray;
            }
            MultivalueProperty.processRecords(result, records, valueProcessor);
            String[] stringArray = result.toArray(new String[result.size()]);
            return stringArray;
        }
        catch (IOException e) {
            throw new IllegalStateException("Property: '" + key + "' doesn't contain a valid CSV value: '" + value + "'", e);
        }
    }

    private static void processRecords(List<String> result, List<CSVRecord> records, Function<String, String> valueProcessor) {
        for (CSVRecord csvRecord : records) {
            String next;
            Iterator it = csvRecord.iterator();
            if (!result.isEmpty() && !(next = (String)it.next()).isEmpty()) {
                int lastItemIdx = result.size() - 1;
                String previous = result.get(lastItemIdx);
                if (previous.isEmpty()) {
                    result.set(lastItemIdx, valueProcessor.apply(next));
                } else {
                    result.set(lastItemIdx, valueProcessor.apply(previous + "\n" + next));
                }
            }
            it.forEachRemaining(s -> {
                String apply = (String)valueProcessor.apply((String)s);
                result.add(apply);
            });
        }
    }

    @VisibleForTesting
    static String trimFieldsAndRemoveEmptyFields(String str) {
        char[] chars = str.toCharArray();
        char[] res = new char[chars.length];
        boolean inField = false;
        boolean inQuotes = false;
        int resI = 0;
        for (int i = 0; i < chars.length; ++i) {
            boolean isTrimmed;
            boolean isSeparator;
            boolean bl = isSeparator = chars[i] == ',';
            if (!inQuotes && isSeparator) {
                inField = false;
                if (resI <= 0) continue;
                resI = MultivalueProperty.retroTrim(res, resI);
                continue;
            }
            boolean bl2 = isTrimmed = !inQuotes && MultivalueProperty.istrimmable(chars[i]);
            if (isTrimmed && !inField) continue;
            boolean isEscape = MultivalueProperty.isEscapeChar(chars[i]);
            if (isEscape) {
                boolean bl3 = inQuotes = !inQuotes;
            }
            if (!inField && resI > 0) {
                res[resI] = 44;
                ++resI;
            }
            inField = true;
            res[resI] = chars[i];
            ++resI;
        }
        if (!inQuotes) {
            resI = MultivalueProperty.retroTrim(res, resI);
        }
        return new String(res, 0, resI);
    }

    private static boolean isEscapeChar(char aChar) {
        return aChar == '\"';
    }

    private static boolean istrimmable(char aChar) {
        return aChar <= ' ';
    }

    private static int retroTrim(char[] res, int resI) {
        int i;
        for (i = resI; i >= 1; --i) {
            if (MultivalueProperty.istrimmable(res[i - 1])) continue;
            return i;
        }
        return i;
    }
}

