/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.profiles;

import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.codehaus.staxmate.SMInputFactory;
import org.codehaus.staxmate.in.SMHierarchicCursor;
import org.codehaus.staxmate.in.SMInputCursor;
import org.sonar.api.ce.ComputeEngineSide;
import org.sonar.api.profiles.RulesProfile;
import org.sonar.api.rules.ActiveRule;
import org.sonar.api.rules.Rule;
import org.sonar.api.rules.RuleFinder;
import org.sonar.api.rules.RulePriority;
import org.sonar.api.server.ServerSide;
import org.sonar.api.utils.ValidationMessages;

@ServerSide
@ComputeEngineSide
public class XMLProfileParser {
    private final RuleFinder ruleFinder;

    @Deprecated
    public XMLProfileParser(RuleFinder ruleFinder) {
        this.ruleFinder = ruleFinder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RulesProfile parseResource(ClassLoader classloader, String xmlClassPath, ValidationMessages messages) {
        InputStreamReader reader = new InputStreamReader(classloader.getResourceAsStream(xmlClassPath), StandardCharsets.UTF_8);
        try {
            RulesProfile rulesProfile = this.parse(reader, messages);
            return rulesProfile;
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
        }
    }

    public RulesProfile parse(Reader reader, ValidationMessages messages) {
        RulesProfile profile = RulesProfile.create();
        SMInputFactory inputFactory = XMLProfileParser.initStax();
        try {
            SMHierarchicCursor rootC = inputFactory.rootElementCursor(reader);
            rootC.advance();
            SMInputCursor cursor = rootC.childElementCursor();
            while (cursor.getNext() != null) {
                String nodeName = cursor.getLocalName();
                if (StringUtils.equals((String)"rules", (String)nodeName)) {
                    SMInputCursor rulesCursor = cursor.childElementCursor("rule");
                    this.processRules(rulesCursor, profile, messages);
                    continue;
                }
                if (StringUtils.equals((String)"name", (String)nodeName)) {
                    profile.setName(StringUtils.trim((String)cursor.collectDescendantText(false)));
                    continue;
                }
                if (!StringUtils.equals((String)"language", (String)nodeName)) continue;
                profile.setLanguage(StringUtils.trim((String)cursor.collectDescendantText(false)));
            }
        }
        catch (XMLStreamException e) {
            messages.addErrorText("XML is not valid: " + e.getMessage());
        }
        XMLProfileParser.checkProfile(profile, messages);
        return profile;
    }

    private static void checkProfile(RulesProfile profile, ValidationMessages messages) {
        if (StringUtils.isBlank((String)profile.getName())) {
            messages.addErrorText("The mandatory node <name> is missing.");
        }
        if (StringUtils.isBlank((String)profile.getLanguage())) {
            messages.addErrorText("The mandatory node <language> is missing.");
        }
    }

    private static SMInputFactory initStax() {
        XMLInputFactory xmlFactory = XMLInputFactory.newInstance();
        xmlFactory.setProperty("javax.xml.stream.isCoalescing", Boolean.TRUE);
        xmlFactory.setProperty("javax.xml.stream.isNamespaceAware", Boolean.FALSE);
        xmlFactory.setProperty("javax.xml.stream.supportDTD", Boolean.FALSE);
        xmlFactory.setProperty("javax.xml.stream.isValidating", Boolean.FALSE);
        return new SMInputFactory(xmlFactory);
    }

    private void processRules(SMInputCursor rulesCursor, RulesProfile profile, ValidationMessages messages) throws XMLStreamException {
        HashMap<String, String> parameters = new HashMap<String, String>();
        while (rulesCursor.getNext() != null) {
            SMInputCursor ruleCursor = rulesCursor.childElementCursor();
            String repositoryKey = null;
            String key = null;
            RulePriority priority = null;
            parameters.clear();
            while (ruleCursor.getNext() != null) {
                String nodeName = ruleCursor.getLocalName();
                if (StringUtils.equals((String)"repositoryKey", (String)nodeName)) {
                    repositoryKey = StringUtils.trim((String)ruleCursor.collectDescendantText(false));
                    continue;
                }
                if (StringUtils.equals((String)"key", (String)nodeName)) {
                    key = StringUtils.trim((String)ruleCursor.collectDescendantText(false));
                    continue;
                }
                if (StringUtils.equals((String)"priority", (String)nodeName)) {
                    priority = RulePriority.valueOf(StringUtils.trim((String)ruleCursor.collectDescendantText(false)));
                    continue;
                }
                if (!StringUtils.equals((String)"parameters", (String)nodeName)) continue;
                SMInputCursor propsCursor = ruleCursor.childElementCursor("parameter");
                XMLProfileParser.processParameters(propsCursor, parameters);
            }
            Rule rule = this.ruleFinder.findByKey(repositoryKey, key);
            if (rule == null) {
                messages.addWarningText("Rule not found: " + XMLProfileParser.ruleToString(repositoryKey, key));
                continue;
            }
            ActiveRule activeRule = profile.activateRule(rule, priority);
            for (Map.Entry entry : parameters.entrySet()) {
                if (rule.getParam((String)entry.getKey()) == null) {
                    messages.addWarningText("The parameter '" + (String)entry.getKey() + "' does not exist in the rule: " + XMLProfileParser.ruleToString(repositoryKey, key));
                    continue;
                }
                activeRule.setParameter((String)entry.getKey(), (String)entry.getValue());
            }
        }
    }

    private static String ruleToString(String repositoryKey, String key) {
        return "[repository=" + repositoryKey + ", key=" + key + "]";
    }

    private static void processParameters(SMInputCursor propsCursor, Map<String, String> parameters) throws XMLStreamException {
        while (propsCursor.getNext() != null) {
            SMInputCursor propCursor = propsCursor.childElementCursor();
            String key = null;
            String value = null;
            while (propCursor.getNext() != null) {
                String nodeName = propCursor.getLocalName();
                if (StringUtils.equals((String)"key", (String)nodeName)) {
                    key = StringUtils.trim((String)propCursor.collectDescendantText(false));
                    continue;
                }
                if (!StringUtils.equals((String)"value", (String)nodeName)) continue;
                value = StringUtils.trim((String)propCursor.collectDescendantText(false));
            }
            if (key == null) continue;
            parameters.put(key, value);
        }
    }
}

