/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.html.checks.comments;

import com.google.common.collect.ImmutableSet;
import org.apache.commons.lang.StringUtils;
import org.sonar.check.Rule;
import org.sonar.plugins.html.checks.AbstractPageCheck;
import org.sonar.plugins.html.node.CommentNode;
import org.sonarsource.analyzer.recognizers.CodeRecognizer;
import org.sonarsource.analyzer.recognizers.ContainsDetector;
import org.sonarsource.analyzer.recognizers.EndWithDetector;
import org.sonarsource.analyzer.recognizers.LanguageFootprint;

@Rule(key="AvoidCommentedOutCodeCheck")
public class AvoidCommentedOutCodeCheck
extends AbstractPageCheck {
    private static final double THRESHOLD = 0.9;
    private static final LanguageFootprint LANGUAGE_FOOTPRINT = () -> ImmutableSet.of(new ContainsDetector(0.7, "=\"", "='"), new ContainsDetector(0.8, "/>", "</", "<%", "%>"), new EndWithDetector(0.9, '>'));
    private static final CodeRecognizer CODE_RECOGNIZER = new CodeRecognizer(0.9, LANGUAGE_FOOTPRINT);

    @Override
    public void comment(CommentNode node) {
        String comment;
        if (node.isHtml() && !(comment = node.getCode()).startsWith("<!--[if") && !StringUtils.containsIgnoreCase(comment, "copyright") && CODE_RECOGNIZER.isLineOfCode(comment)) {
            this.createViolation(node.getStartLinePosition(), "Remove this commented out code.");
        }
    }
}

