/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.html.checks.scripting;

import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.plugins.html.checks.AbstractPageCheck;
import org.sonar.plugins.html.node.TagNode;
import org.sonar.plugins.html.node.TextNode;

@Rule(key="LongJavaScriptCheck")
public class LongJavaScriptCheck
extends AbstractPageCheck {
    private static final int DEFAULT_MAX_LINES = 5;
    @RuleProperty(key="maxLines", description="Max Lines (Number)", defaultValue="5")
    public int maxLines = 5;
    private int linesOfCode;
    private TagNode scriptNode;

    @Override
    public void characters(TextNode textNode) {
        if (this.scriptNode != null) {
            this.linesOfCode += textNode.getLinesOfCode();
            if (this.linesOfCode > this.maxLines) {
                this.createViolation(this.scriptNode.getStartLinePosition(), "The length of this JS script (" + this.linesOfCode + ") exceeds the maximum set to " + this.maxLines + ".", Double.valueOf(this.linesOfCode) - Double.valueOf(this.maxLines));
                this.scriptNode = null;
            }
        }
    }

    @Override
    public void endElement(TagNode element) {
        this.scriptNode = null;
    }

    @Override
    public void startElement(TagNode element) {
        if ("script".equalsIgnoreCase(element.getNodeName())) {
            this.scriptNode = element;
            this.linesOfCode = 0;
        }
    }
}

