/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.html.checks.sonar;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.plugins.html.checks.AbstractPageCheck;
import org.sonar.plugins.html.node.Attribute;
import org.sonar.plugins.html.node.TagNode;

@Rule(key="S1827")
public class DeprecatedAttributesInHtml5Check
extends AbstractPageCheck {
    private static final Map<String, Set<String>> DEPRECATED;

    @Override
    public void startElement(TagNode element) {
        String nodeName = element.getNodeName();
        String elementName = nodeName.toLowerCase(Locale.ROOT);
        Set<String> deprecatedAttributes = DEPRECATED.get(elementName);
        if (deprecatedAttributes != null) {
            List<Attribute> attributes = element.getAttributes();
            for (Attribute attribute : attributes) {
                if (!DeprecatedAttributesInHtml5Check.isDeprecated(element, deprecatedAttributes, DeprecatedAttributesInHtml5Check.getOriginalAttributeName(attribute.getName()), attribute.getValue().toLowerCase())) continue;
                this.createViolation(element.getStartLinePosition(), "Remove this deprecated \"" + attribute.getName() + "\" attribute.");
            }
        }
    }

    private static boolean isDeprecated(TagNode element, Set<String> deprecatedAttributes, String attributeName, String attributeValue) {
        String elementName = element.getNodeName().toLowerCase(Locale.ROOT);
        if ("img".equals(elementName) && "border".equals(attributeName)) {
            return !"0".equals(attributeValue);
        }
        if ("script".equals(elementName) && "language".equals(attributeName)) {
            return !"javascript".equals(attributeValue);
        }
        if ("a".equals(elementName) && "name".equals(attributeName)) {
            String id = element.getPropertyValue("id");
            return Strings.isNullOrEmpty(id) || !id.equals(attributeValue);
        }
        return deprecatedAttributes.contains(attributeName);
    }

    private static String getOriginalAttributeName(String attributeName) {
        String attributeNameLower = attributeName.toLowerCase(Locale.ENGLISH);
        if (attributeNameLower.startsWith("[") && attributeNameLower.endsWith("]")) {
            return attributeNameLower.substring(1, attributeName.length() - 1);
        }
        return attributeNameLower;
    }

    static {
        String align = "align";
        String background = "background";
        String bgcolor = "bgcolor";
        String vspace = "vspace";
        String width = "width";
        String charoff = "charoff";
        String hspace = "hspace";
        String dataformatas = "dataformatas";
        String datafld = "datafld";
        String datasrc = "datasrc";
        String compact = "compact";
        String border = "border";
        String valign = "valign";
        ImmutableMap.Builder<String, ImmutableSet<String>> builder = ImmutableMap.builder();
        builder.put("a", ImmutableSet.of("charset", "coords", "datafld", "datasrc", "methods", "name", new String[]{"shape", "urn"}));
        builder.put("applet", ImmutableSet.of("datafld", "datasrc"));
        builder.put("area", ImmutableSet.of("nohref"));
        builder.put("body", ImmutableSet.of("alink", "background", "bgcolor", "link", "marginbottom", "marginheight", new String[]{"marginleft", "marginright", "margintop", "marginwidth", "text", "vlink"}));
        builder.put("br", ImmutableSet.of("clear"));
        builder.put("button", ImmutableSet.of("datafld", "dataformatas", "datasrc"));
        builder.put("caption", ImmutableSet.of("align"));
        builder.put("col", ImmutableSet.of("align", "char", "charoff", "valign", "width"));
        builder.put("div", ImmutableSet.of("align", "datafld", "dataformatas", "datasrc"));
        builder.put("dl", ImmutableSet.of("compact"));
        builder.put("embed", ImmutableSet.of("align", "hspace", "name", "vspace"));
        builder.put("fieldset", ImmutableSet.of("datafld"));
        builder.put("form", ImmutableSet.of("accept"));
        builder.put("frame", ImmutableSet.of("datafld", "datasrc"));
        builder.put("h1", ImmutableSet.of("align"));
        builder.put("h2", ImmutableSet.of("align"));
        builder.put("h3", ImmutableSet.of("align"));
        builder.put("h4", ImmutableSet.of("align"));
        builder.put("h5", ImmutableSet.of("align"));
        builder.put("h6", ImmutableSet.of("align"));
        builder.put("head", ImmutableSet.of("profile"));
        builder.put("hr", ImmutableSet.of("align", "color", "noshade", "size", "width"));
        builder.put("html", ImmutableSet.of("version"));
        builder.put("iframe", ImmutableSet.of("align", "allowtransparency", "datafld", "datasrc", "frameborder", "hspace", new String[]{"marginheight", "marginwidth", "scrolling", "vspace"}));
        builder.put("img", ImmutableSet.of("align", "border", "datafld", "datasrc", "hspace", "lowsrc", new String[]{"name", "vspace"}));
        builder.put("input", ImmutableSet.of("align", "datafld", "dataformatas", "datasrc", "hspace", "ismap", new String[]{"usemap", "vspace"}));
        builder.put("label", ImmutableSet.of("datafld", "dataformatas", "datasrc"));
        builder.put("legend", ImmutableSet.of("align", "datafld", "dataformatas", "datasrc"));
        builder.put("li", ImmutableSet.of("type"));
        builder.put("link", ImmutableSet.of("charset", "methods", "target", "urn"));
        builder.put("marquee", ImmutableSet.of("datafld", "dataformatas", "datasrc"));
        builder.put("meta", ImmutableSet.of("scheme"));
        builder.put("object", ImmutableSet.of("align", "archive", "border", "classid", "code", "codebase", new String[]{"codetype", "datafld", "dataformatas", "datasrc", "declare", "hspace", "standby", "vspace"}));
        builder.put("ol", ImmutableSet.of("compact"));
        builder.put("option", ImmutableSet.of("datafld", "dataformatas", "datasrc", "name"));
        builder.put("p", ImmutableSet.of("align"));
        builder.put("param", ImmutableSet.of("datafld", "type", "valuetype"));
        builder.put("params", ImmutableSet.of("type"));
        builder.put("pre", ImmutableSet.of("width"));
        builder.put("script", ImmutableSet.of("event", "for", "langauge"));
        builder.put("select", ImmutableSet.of("datafld", "dataformatas", "datasrc"));
        builder.put("span", ImmutableSet.of("datafld", "dataformatas", "datasrc"));
        builder.put("table", ImmutableSet.of("align", "background", "bgcolor", "bordercolor", "cellpadding", "cellspacing", new String[]{"dataformatas", "datapagesize", "datasrc", "frame", "rules", "summary", "width"}));
        builder.put("text", ImmutableSet.of("body"));
        builder.put("textarea", ImmutableSet.of("datafld", "datasrc"));
        builder.put("tbody", ImmutableSet.of("align", "background", "char", "charoff", "valign"));
        builder.put("thead", ImmutableSet.of("align", "background", "bgcolor", "char", "charoff", "valign", new String[0]));
        builder.put("tfoot", ImmutableSet.of("align", "background", "char", "charoff", "valign"));
        builder.put("td", ImmutableSet.of("align", "axis", "background", "bgcolor", "char", "charoff", new String[]{"height", "nowrap", "scope", "valign", "width"}));
        builder.put("th", ImmutableSet.of("align", "axis", "background", "bgcolor", "char", "charoff", new String[]{"height", "nowrap", "valign", "width"}));
        builder.put("tr", ImmutableSet.of("align", "background", "bgcolor", "char", "charoff", "valign", new String[0]));
        builder.put("ul", ImmutableSet.of("compact", "type"));
        DEPRECATED = builder.build();
    }
}

