/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.html.checks.sonar;

import org.sonar.check.Rule;
import org.sonar.plugins.html.checks.AbstractPageCheck;
import org.sonar.plugins.html.node.TagNode;

@Rule(key="ItemTagNotWithinContainerTagCheck")
public class ItemTagNotWithinContainerTagCheck
extends AbstractPageCheck {
    @Override
    public void startElement(TagNode node) {
        if (ItemTagNotWithinContainerTagCheck.isLi(node) && !ItemTagNotWithinContainerTagCheck.hasLiOrUlOrOlAncestor(node)) {
            this.createViolation(node.getStartLinePosition(), "Surround this <" + node.getNodeName() + "> item tag by a <ul> or <ol> container one.");
        } else if (ItemTagNotWithinContainerTagCheck.isDt(node) && !ItemTagNotWithinContainerTagCheck.hasDtOrDlAncestor(node)) {
            this.createViolation(node.getStartLinePosition(), "Surround this <" + node.getNodeName() + "> item tag by a <dl> container one.");
        }
    }

    private static boolean hasLiOrUlOrOlAncestor(TagNode node) {
        for (TagNode parent = node.getParent(); parent != null; parent = parent.getParent()) {
            if (!ItemTagNotWithinContainerTagCheck.isLi(parent) && !ItemTagNotWithinContainerTagCheck.isUlOrOl(parent)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasDtOrDlAncestor(TagNode node) {
        for (TagNode parent = node.getParent(); parent != null; parent = parent.getParent()) {
            if (!ItemTagNotWithinContainerTagCheck.isDt(parent) && !ItemTagNotWithinContainerTagCheck.isDl(parent)) continue;
            return true;
        }
        return false;
    }

    private static boolean isLi(TagNode node) {
        return "LI".equalsIgnoreCase(node.getNodeName());
    }

    private static boolean isDt(TagNode node) {
        return "DT".equalsIgnoreCase(node.getNodeName());
    }

    private static boolean isUlOrOl(TagNode node) {
        return ItemTagNotWithinContainerTagCheck.isUl(node) || ItemTagNotWithinContainerTagCheck.isOl(node);
    }

    private static boolean isUl(TagNode node) {
        return "UL".equalsIgnoreCase(node.getNodeName());
    }

    private static boolean isOl(TagNode node) {
        return "OL".equalsIgnoreCase(node.getNodeName());
    }

    private static boolean isDl(TagNode node) {
        return "DL".equalsIgnoreCase(node.getNodeName());
    }
}

