/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.html.checks.sonar;

import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.html.checks.AbstractPageCheck;
import org.sonar.plugins.html.node.Node;
import org.sonar.plugins.html.node.TagNode;

@Rule(key="NonConsecutiveHeadingCheck")
public class NonConsecutiveHeadingCheck
extends AbstractPageCheck {
    private final int[] firstUsage = new int[6];

    @Override
    public void startDocument(List<Node> nodes) {
        for (int i = 0; i < this.firstUsage.length; ++i) {
            this.firstUsage[i] = 0;
        }
    }

    @Override
    public void startElement(TagNode node) {
        int index;
        if (NonConsecutiveHeadingCheck.isHeadingTag(node) && this.firstUsage[index = node.getNodeName().charAt(1) - 49] == 0) {
            this.firstUsage[index] = node.getStartLinePosition();
        }
    }

    @Override
    public void endDocument() {
        for (int i = this.firstUsage.length - 1; i > 0; --i) {
            if (this.firstUsage[i] == 0 || this.firstUsage[i - 1] != 0) continue;
            this.createViolation(this.firstUsage[i], "Do not skip level H" + i + ".");
        }
    }

    private static boolean isHeadingTag(TagNode node) {
        return node.getNodeName().length() == 2 && Character.toUpperCase(node.getNodeName().charAt(0)) == 'H' && node.getNodeName().charAt(1) >= '1' && node.getNodeName().charAt(1) <= '6';
    }
}

