/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.html.core;

import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Map;
import java.util.stream.Stream;
import org.sonar.api.SonarProduct;
import org.sonar.api.batch.fs.FilePredicate;
import org.sonar.api.batch.fs.FilePredicates;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.measure.Metric;
import org.sonar.api.batch.rule.CheckFactory;
import org.sonar.api.batch.rule.Checks;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.batch.sensor.issue.NewIssue;
import org.sonar.api.batch.sensor.issue.NewIssueLocation;
import org.sonar.api.issue.NoSonarFilter;
import org.sonar.api.measures.FileLinesContext;
import org.sonar.api.measures.FileLinesContextFactory;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.plugins.html.analyzers.ComplexityVisitor;
import org.sonar.plugins.html.analyzers.PageCountLines;
import org.sonar.plugins.html.checks.AbstractPageCheck;
import org.sonar.plugins.html.checks.HtmlIssue;
import org.sonar.plugins.html.core.HtmlTokensVisitor;
import org.sonar.plugins.html.lex.PageLexer;
import org.sonar.plugins.html.rules.CheckClasses;
import org.sonar.plugins.html.visitor.DefaultNodeVisitor;
import org.sonar.plugins.html.visitor.HtmlAstScanner;
import org.sonar.plugins.html.visitor.HtmlSourceCode;
import org.sonar.plugins.html.visitor.NoSonarScanner;

public final class HtmlSensor
implements Sensor {
    private static final Logger LOG = Loggers.get(HtmlSensor.class);
    private static final String[] OTHER_FILE_SUFFIXES = new String[]{"php", "php3", "php4", "php5", "phtml", "inc"};
    private final NoSonarFilter noSonarFilter;
    private final Checks<Object> checks;
    private final FileLinesContextFactory fileLinesContextFactory;

    public HtmlSensor(NoSonarFilter noSonarFilter, FileLinesContextFactory fileLinesContextFactory, CheckFactory checkFactory) {
        this.noSonarFilter = noSonarFilter;
        this.checks = checkFactory.create("Web").addAnnotatedChecks(CheckClasses.getCheckClasses());
        this.fileLinesContextFactory = fileLinesContextFactory;
    }

    public void describe(SensorDescriptor descriptor) {
        descriptor.name("HTML").onlyOnFileType(InputFile.Type.MAIN);
    }

    public void execute(SensorContext sensorContext) {
        PageLexer lexer = new PageLexer();
        FileSystem fileSystem = sensorContext.fileSystem();
        HtmlAstScanner scanner = this.setupScanner(sensorContext);
        FilePredicates predicates = fileSystem.predicates();
        Iterable inputFiles = fileSystem.inputFiles(predicates.and(predicates.hasType(InputFile.Type.MAIN), predicates.or(predicates.hasLanguages(new String[]{"web", "jsp"}), predicates.or((FilePredicate[])Stream.of(OTHER_FILE_SUFFIXES).map(arg_0 -> ((FilePredicates)predicates).hasExtension(arg_0)).toArray(FilePredicate[]::new)))));
        for (InputFile inputFile : inputFiles) {
            if (sensorContext.isCancelled()) {
                return;
            }
            HtmlSourceCode sourceCode = new HtmlSourceCode(inputFile);
            try {
                StringReader reader = new StringReader(inputFile.contents());
                Throwable throwable = null;
                try {
                    scanner.scan(lexer.parse(reader), sourceCode, fileSystem.encoding());
                    HtmlSensor.saveMetrics(sensorContext, sourceCode);
                    this.saveLineLevelMeasures(inputFile, sourceCode);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (reader == null) continue;
                    if (throwable != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ((Reader)reader).close();
                }
            }
            catch (Exception e) {
                LOG.error("Cannot analyze file " + inputFile, (Throwable)e);
                sensorContext.newAnalysisError().onFile(inputFile).message(e.getMessage()).save();
            }
        }
    }

    private static void saveMetrics(SensorContext context, HtmlSourceCode sourceCode) {
        InputFile inputFile = sourceCode.inputFile();
        for (Map.Entry<org.sonar.api.measures.Metric<Integer>, Integer> entry : sourceCode.getMeasures().entrySet()) {
            context.newMeasure().on((InputComponent)inputFile).forMetric((Metric)entry.getKey()).withValue((Serializable)entry.getValue()).save();
        }
        for (HtmlIssue issue : sourceCode.getIssues()) {
            NewIssue newIssue = context.newIssue().forRule(issue.ruleKey()).gap(issue.cost());
            Integer line = issue.line();
            NewIssueLocation location = newIssue.newLocation().on((InputComponent)inputFile).message(issue.message());
            if (line != null) {
                location.at(inputFile.selectLine(line.intValue()));
            }
            newIssue.at(location);
            newIssue.save();
        }
    }

    private void saveLineLevelMeasures(InputFile inputFile, HtmlSourceCode htmlSourceCode) {
        FileLinesContext fileLinesContext = this.fileLinesContextFactory.createFor(inputFile);
        for (Integer line : htmlSourceCode.getDetailedLinesOfCode()) {
            fileLinesContext.setIntValue("ncloc_data", line.intValue(), 1);
        }
        fileLinesContext.save();
    }

    private HtmlAstScanner setupScanner(SensorContext context) {
        ArrayList<DefaultNodeVisitor> visitors = new ArrayList<DefaultNodeVisitor>();
        if (context.runtime().getProduct() != SonarProduct.SONARLINT) {
            visitors.add(new HtmlTokensVisitor(context));
        }
        visitors.add(new PageCountLines());
        visitors.add(new ComplexityVisitor());
        visitors.add(new NoSonarScanner(this.noSonarFilter));
        HtmlAstScanner scanner = new HtmlAstScanner(visitors);
        for (Object check : this.checks.all()) {
            ((AbstractPageCheck)check).setRuleKey(this.checks.ruleKey(check));
            scanner.addVisitor((AbstractPageCheck)check);
        }
        return scanner;
    }
}

