/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.html.node;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.sonar.plugins.html.node.Attribute;
import org.sonar.plugins.html.node.Node;
import org.sonar.plugins.html.node.NodeType;

public class TagNode
extends Node {
    private final List<Attribute> attributes = new ArrayList<Attribute>();
    private final List<TagNode> children = new ArrayList<TagNode>();
    private String nodeName;
    private TagNode parent;

    public TagNode() {
        super(NodeType.TAG);
    }

    protected TagNode(NodeType nodeType) {
        super(nodeType);
    }

    public boolean equalsElementName(String elementName) {
        return StringUtils.equalsIgnoreCase(this.getLocalName(), elementName) || StringUtils.equalsIgnoreCase(this.getNodeName(), elementName);
    }

    @Nullable
    public Attribute getProperty(String propertyName) {
        String angularProperty = "[" + propertyName + "]";
        for (Attribute a : this.attributes) {
            String attributeName = a.getName();
            if (!propertyName.equalsIgnoreCase(attributeName) && !angularProperty.equalsIgnoreCase(attributeName)) continue;
            return a;
        }
        return null;
    }

    @Nullable
    public String getPropertyValue(String propertyName) {
        Attribute property = this.getProperty(propertyName);
        if (property != null) {
            return property.getValue();
        }
        return null;
    }

    public boolean hasProperty(String propertyName) {
        return this.getProperty(propertyName) != null;
    }

    public String getAttribute(String attributeName) {
        for (Attribute a : this.attributes) {
            if (!attributeName.equalsIgnoreCase(a.getName())) continue;
            return a.getValue();
        }
        return null;
    }

    public List<Attribute> getAttributes() {
        return this.attributes;
    }

    public List<TagNode> getChildren() {
        return this.children;
    }

    public String getLocalName() {
        String localPart = StringUtils.substringAfterLast(this.getNodeName(), ":");
        if (StringUtils.isEmpty(localPart)) {
            return this.nodeName;
        }
        return localPart;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    @Nullable
    public TagNode getParent() {
        return this.parent;
    }

    public boolean hasEnd() {
        return this.getCode().endsWith("/>");
    }

    public boolean isEndElement() {
        return this.getCode().startsWith("</");
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    public void setParent(@Nullable TagNode parent) {
        this.parent = parent;
        if (parent != null) {
            parent.getChildren().add(this);
        }
    }
}

