/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.analyzer.recognizers;

public abstract class Detector {
    private final double probability;

    public Detector(double probability) {
        if (probability < 0.0 || probability > 1.0) {
            throw new IllegalArgumentException("probability should be between [0 .. 1]");
        }
        this.probability = probability;
    }

    public abstract int scan(String var1);

    public final double recognition(String line) {
        int matchers = this.scan(line);
        if (matchers == 0) {
            return 0.0;
        }
        return 1.0 - Math.pow(1.0 - this.probability, this.scan(line));
    }
}

