/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.issue.tracking;

import com.google.common.base.Strings;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import java.util.List;
import java.util.Set;
import org.sonar.core.hash.SourceLineHashesComputer;

public class LineHashSequence {
    private final List<String> hashes;
    private final SetMultimap<String, Integer> lineByHash;

    public LineHashSequence(List<String> hashes) {
        this.hashes = hashes;
        this.lineByHash = HashMultimap.create();
        int lineNo = 1;
        for (String hash : hashes) {
            this.lineByHash.put(hash, lineNo);
            ++lineNo;
        }
    }

    public int length() {
        return this.hashes.size();
    }

    public boolean hasLine(int line) {
        return 0 < line && line <= this.hashes.size();
    }

    public Set<Integer> getLinesForHash(String hash) {
        return this.lineByHash.get(hash);
    }

    public String getHashForLine(int line) {
        if (line > 0 && line <= this.hashes.size()) {
            return Strings.nullToEmpty(this.hashes.get(line - 1));
        }
        return "";
    }

    List<String> getHashes() {
        return this.hashes;
    }

    public static LineHashSequence createForLines(List<String> lines) {
        SourceLineHashesComputer hashesComputer = new SourceLineHashesComputer(lines.size());
        for (String line : lines) {
            hashesComputer.addLine(line);
        }
        return new LineHashSequence(hashesComputer.getLineHashes());
    }
}

