/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.platform;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Predicate;
import java.util.zip.ZipEntry;
import org.apache.commons.io.FileUtils;
import org.sonar.core.platform.ExplodedPlugin;
import org.sonar.core.platform.PluginInfo;

public abstract class PluginJarExploder {
    protected static final String LIB_RELATIVE_PATH_IN_JAR = "META-INF/lib";

    public abstract ExplodedPlugin explode(PluginInfo var1);

    protected Predicate<ZipEntry> newLibFilter() {
        return ze -> ze.getName().startsWith(LIB_RELATIVE_PATH_IN_JAR);
    }

    protected ExplodedPlugin explodeFromUnzippedDir(String pluginKey, File jarFile, File unzippedDir) {
        File libDir = new File(unzippedDir, LIB_RELATIVE_PATH_IN_JAR);
        Collection<File> libs = libDir.isDirectory() && libDir.exists() ? FileUtils.listFiles(libDir, null, false) : Collections.emptyList();
        return new ExplodedPlugin(pluginKey, jarFile, libs);
    }
}

