/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.bootstrap;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.concurrent.Immutable;
import org.sonar.api.config.Encryption;

@Immutable
public class RawScannerProperties {
    private final Map<String, String> properties;
    private final Encryption encryption;

    public RawScannerProperties(Map<String, String> properties) {
        this.encryption = new Encryption(properties.get("sonar.secretKeyPath"));
        HashMap<String, String> decryptedProps = new HashMap<String, String>(properties.size());
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            String value = entry.getValue();
            if (value != null && this.encryption.isEncrypted(value)) {
                try {
                    value = this.encryption.decrypt(value);
                }
                catch (Exception e) {
                    throw new IllegalStateException("Fail to decrypt the property " + entry.getKey() + ". Please check your secret key.", e);
                }
            }
            decryptedProps.put(entry.getKey(), value);
        }
        this.properties = decryptedProps;
    }

    public Encryption getEncryption() {
        return this.encryption;
    }

    public Map<String, String> properties() {
        return ImmutableMap.copyOf(this.properties);
    }

    public String property(String key) {
        return this.properties.get(key);
    }
}

