/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.issue;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;
import org.sonar.api.scan.issue.filter.FilterableIssue;
import org.sonar.api.scan.issue.filter.IssueFilter;
import org.sonar.api.scan.issue.filter.IssueFilterChain;

@ThreadSafe
public class DefaultIssueFilterChain
implements IssueFilterChain {
    private final List<IssueFilter> filters;

    public DefaultIssueFilterChain(IssueFilter ... filters) {
        this.filters = Collections.unmodifiableList(Arrays.asList(filters));
    }

    public DefaultIssueFilterChain() {
        this.filters = Collections.emptyList();
    }

    private DefaultIssueFilterChain(List<IssueFilter> filters) {
        this.filters = filters;
    }

    @Override
    public boolean accept(FilterableIssue issue) {
        if (this.filters.isEmpty()) {
            return true;
        }
        return this.filters.get(0).accept(issue, new DefaultIssueFilterChain(this.filters.subList(1, this.filters.size())));
    }
}

