/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.scan.filesystem;

import com.google.common.base.Preconditions;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Table;
import com.google.common.collect.TreeBasedTable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.internal.DefaultFileSystem;
import org.sonar.api.batch.fs.internal.DefaultInputFile;
import org.sonar.api.batch.fs.internal.DefaultInputModule;
import org.sonar.api.batch.fs.internal.FileExtensionPredicate;
import org.sonar.scanner.scan.branch.BranchConfiguration;

public class InputComponentStore
extends DefaultFileSystem.Cache {
    private final SortedSet<String> globalLanguagesCache = new TreeSet<String>();
    private final Map<String, SortedSet<String>> languagesCache = new HashMap<String, SortedSet<String>>();
    private final Map<String, InputFile> globalInputFileCache = new HashMap<String, InputFile>();
    private final Table<String, String, InputFile> inputFileByModuleCache = TreeBasedTable.create();
    private final Map<String, DefaultInputModule> inputModuleCache = new HashMap<String, DefaultInputModule>();
    private final Map<String, InputComponent> inputComponents = new HashMap<String, InputComponent>();
    private final SetMultimap<String, InputFile> filesByNameCache = LinkedHashMultimap.create();
    private final SetMultimap<String, InputFile> filesByExtensionCache = LinkedHashMultimap.create();
    private final BranchConfiguration branchConfiguration;

    public InputComponentStore(BranchConfiguration branchConfiguration) {
        this.branchConfiguration = branchConfiguration;
    }

    public Collection<InputComponent> all() {
        return this.inputComponents.values();
    }

    private Stream<DefaultInputFile> allFilesToPublishStream() {
        return this.globalInputFileCache.values().stream().map(f -> (DefaultInputFile)f).filter(DefaultInputFile::isPublished);
    }

    public Iterable<DefaultInputFile> allFilesToPublish() {
        return this.allFilesToPublishStream()::iterator;
    }

    public Iterable<DefaultInputFile> allChangedFilesToPublish() {
        return this.allFilesToPublishStream().filter(f -> !this.branchConfiguration.isShortOrPullRequest() || f.status() != InputFile.Status.SAME)::iterator;
    }

    public Collection<InputFile> inputFiles() {
        return this.globalInputFileCache.values();
    }

    public InputComponent getByKey(String key) {
        return this.inputComponents.get(key);
    }

    public Iterable<InputFile> filesByModule(String moduleKey) {
        return this.inputFileByModuleCache.row(moduleKey).values();
    }

    public InputComponentStore put(String moduleKey, InputFile inputFile) {
        DefaultInputFile file = (DefaultInputFile)inputFile;
        this.addToLanguageCache(moduleKey, file);
        this.inputFileByModuleCache.put(moduleKey, file.getModuleRelativePath(), inputFile);
        this.globalInputFileCache.put(file.getProjectRelativePath(), inputFile);
        this.inputComponents.put(inputFile.key(), inputFile);
        this.filesByNameCache.put(inputFile.filename(), inputFile);
        this.filesByExtensionCache.put(FileExtensionPredicate.getExtension(inputFile), inputFile);
        return this;
    }

    private void addToLanguageCache(String moduleKey, DefaultInputFile inputFile) {
        String language = inputFile.language();
        if (language != null) {
            this.globalLanguagesCache.add(language);
            this.languagesCache.computeIfAbsent(moduleKey, k -> new TreeSet()).add(language);
        }
    }

    @CheckForNull
    public InputFile getFile(String moduleKey, String relativePath) {
        return this.inputFileByModuleCache.get(moduleKey, relativePath);
    }

    @Override
    @CheckForNull
    public InputFile inputFile(String relativePath) {
        return this.globalInputFileCache.get(relativePath);
    }

    @CheckForNull
    public DefaultInputModule getModule(String moduleKeyWithBranch) {
        return this.inputModuleCache.get(moduleKeyWithBranch);
    }

    @CheckForNull
    public DefaultInputModule findModule(DefaultInputFile file) {
        return this.inputFileByModuleCache.cellSet().stream().filter(c -> ((InputFile)c.getValue()).equals(file)).findFirst().map(c -> (DefaultInputModule)this.inputComponents.get(c.getRowKey())).orElse(null);
    }

    public void put(DefaultInputModule inputModule) {
        String key = inputModule.key();
        String keyWithBranch = inputModule.getKeyWithBranch();
        Preconditions.checkNotNull(inputModule);
        Preconditions.checkState(!this.inputComponents.containsKey(key), "Module '%s' already indexed", key);
        Preconditions.checkState(!this.inputModuleCache.containsKey(keyWithBranch), "Module '%s' already indexed", keyWithBranch);
        this.inputComponents.put(key, inputModule);
        this.inputModuleCache.put(keyWithBranch, inputModule);
    }

    @Override
    public Iterable<InputFile> getFilesByName(String filename) {
        return this.filesByNameCache.get(filename);
    }

    @Override
    public Iterable<InputFile> getFilesByExtension(String extension) {
        return this.filesByExtensionCache.get(extension);
    }

    @Override
    public SortedSet<String> languages() {
        return this.globalLanguagesCache;
    }

    public SortedSet<String> languages(String moduleKey) {
        return this.languagesCache.getOrDefault(moduleKey, Collections.emptySortedSet());
    }

    public Collection<DefaultInputModule> allModules() {
        return this.inputModuleCache.values();
    }

    @Override
    protected void doAdd(InputFile inputFile) {
        throw new UnsupportedOperationException();
    }
}

