/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.scm;

import java.nio.file.Path;
import java.util.Collection;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.picocontainer.injectors.ProviderAdapter;
import org.sonar.api.batch.fs.internal.DefaultInputProject;
import org.sonar.api.batch.scm.ScmProvider;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.api.utils.log.Profiler;
import org.sonar.scanner.scan.branch.BranchConfiguration;
import org.sonar.scanner.scm.ScmChangedFiles;
import org.sonar.scanner.scm.ScmConfiguration;
import org.sonar.scanner.util.ScannerUtils;

public class ScmChangedFilesProvider
extends ProviderAdapter {
    private static final Logger LOG = Loggers.get(ScmChangedFilesProvider.class);
    private static final String LOG_MSG = "SCM collecting changed files in the branch";
    private ScmChangedFiles scmBranchChangedFiles;

    public ScmChangedFiles provide(@org.picocontainer.annotations.Nullable ScmConfiguration scmConfiguration, BranchConfiguration branchConfiguration, DefaultInputProject project) {
        if (this.scmBranchChangedFiles == null) {
            if (scmConfiguration == null) {
                this.scmBranchChangedFiles = new ScmChangedFiles(null);
            } else {
                Path rootBaseDir = project.getBaseDir();
                Collection<Path> changedFiles = ScmChangedFilesProvider.loadChangedFilesIfNeeded(scmConfiguration, branchConfiguration, rootBaseDir);
                ScmChangedFilesProvider.validatePaths(changedFiles);
                this.scmBranchChangedFiles = new ScmChangedFiles(changedFiles);
            }
        }
        return this.scmBranchChangedFiles;
    }

    private static void validatePaths(@Nullable Collection<Path> paths) {
        if (paths != null && paths.stream().anyMatch(p -> !p.isAbsolute())) {
            throw new IllegalStateException("SCM provider returned a changed file with a relative path but paths must be absolute. Please fix the provider.");
        }
    }

    @CheckForNull
    private static Collection<Path> loadChangedFilesIfNeeded(ScmConfiguration scmConfiguration, BranchConfiguration branchConfiguration, Path rootBaseDir) {
        if (branchConfiguration.isShortOrPullRequest() && branchConfiguration.targetScmBranch() != null) {
            ScmProvider scmProvider = scmConfiguration.provider();
            if (scmProvider != null) {
                Profiler profiler = Profiler.create(LOG).startInfo(LOG_MSG);
                Set<Path> changedFiles = scmProvider.branchChangedFiles(branchConfiguration.targetScmBranch(), rootBaseDir);
                profiler.stopInfo();
                if (changedFiles != null) {
                    LOG.debug("SCM reported {} {} changed in the branch", (Object)changedFiles.size(), (Object)ScannerUtils.pluralize("file", changedFiles.size()));
                    return changedFiles;
                }
            }
            LOG.debug("SCM information about changed files in the branch is not available");
        }
        return null;
    }
}

