/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.sensor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.sonar.api.batch.fs.internal.DefaultInputModule;
import org.sonar.api.batch.fs.internal.InputModuleHierarchy;
import org.sonar.api.batch.fs.internal.SensorStrategy;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.core.util.logs.Profiler;
import org.sonar.scanner.bootstrap.ScannerPluginRepository;
import org.sonar.scanner.sensor.ModuleSensorExtensionDictionnary;
import org.sonar.scanner.sensor.ModuleSensorWrapper;

public class ModuleSensorsExecutor {
    private static final Logger LOG = Loggers.get(ModuleSensorsExecutor.class);
    private static final Profiler profiler = Profiler.create(LOG);
    private final ModuleSensorExtensionDictionnary selector;
    private final SensorStrategy strategy;
    private final ScannerPluginRepository pluginRepo;
    private final boolean isRoot;

    public ModuleSensorsExecutor(ModuleSensorExtensionDictionnary selector, DefaultInputModule module, InputModuleHierarchy hierarchy, SensorStrategy strategy, ScannerPluginRepository pluginRepo) {
        this.selector = selector;
        this.strategy = strategy;
        this.pluginRepo = pluginRepo;
        this.isRoot = hierarchy.isRoot(module);
    }

    public void execute() {
        ArrayList<ModuleSensorWrapper> moduleSensors = new ArrayList<ModuleSensorWrapper>();
        this.withModuleStrategy(() -> moduleSensors.addAll(this.selector.selectSensors(false)));
        ArrayList<ModuleSensorWrapper> deprecatedGlobalSensors = new ArrayList<ModuleSensorWrapper>();
        if (this.isRoot) {
            deprecatedGlobalSensors.addAll(this.selector.selectSensors(true));
        }
        this.printSensors(moduleSensors, deprecatedGlobalSensors);
        this.withModuleStrategy(() -> this.execute(moduleSensors));
        if (this.isRoot) {
            this.execute(deprecatedGlobalSensors);
        }
    }

    private void printSensors(Collection<ModuleSensorWrapper> moduleSensors, Collection<ModuleSensorWrapper> globalSensors) {
        String sensors = Stream.concat(moduleSensors.stream(), globalSensors.stream()).map(Object::toString).collect(Collectors.joining(" -> "));
        LOG.debug("Sensors : {}", (Object)sensors);
    }

    private void withModuleStrategy(Runnable r) {
        boolean orig = this.strategy.isGlobal();
        this.strategy.setGlobal(false);
        r.run();
        this.strategy.setGlobal(orig);
    }

    private void execute(Collection<ModuleSensorWrapper> sensors) {
        for (ModuleSensorWrapper sensor : sensors) {
            String sensorName = this.getSensorName(sensor);
            profiler.startInfo("Sensor " + sensorName);
            sensor.analyse();
            profiler.stopInfo();
        }
    }

    private String getSensorName(ModuleSensorWrapper sensor) {
        ClassLoader cl = ModuleSensorsExecutor.getSensorClassLoader(sensor);
        String pluginKey = this.pluginRepo.getPluginKey(cl);
        if (pluginKey != null) {
            return sensor.toString() + " [" + pluginKey + "]";
        }
        return sensor.toString();
    }

    private static ClassLoader getSensorClassLoader(ModuleSensorWrapper sensor) {
        return ((Sensor)sensor.wrappedSensor()).getClass().getClassLoader();
    }
}

