/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.cache.impl;

import com.hazelcast.cache.impl.ICacheInternal;
import com.hazelcast.client.impl.ClientMessageDecoder;
import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.spi.ClientContext;
import com.hazelcast.client.spi.ClientProxy;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.client.spi.impl.ClientInvocationFuture;
import com.hazelcast.client.util.ClientDelegatingFuture;
import com.hazelcast.config.CacheConfig;
import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.core.HazelcastInstanceAware;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.serialization.SerializationService;
import com.hazelcast.util.ExceptionUtil;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.cache.CacheException;
import javax.cache.integration.CompletionListener;

abstract class AbstractClientCacheProxyBase<K, V>
extends ClientProxy
implements ICacheInternal<K, V> {
    static final int TIMEOUT = 10;
    private static final ClientMessageDecoder LOAD_ALL_DECODER = new ClientMessageDecoder(){

        @Override
        public <T> T decodeClientMessage(ClientMessage clientMessage) {
            return (T)Boolean.TRUE;
        }
    };
    private static final CompletionListener NULL_COMPLETION_LISTENER = new CompletionListener(){

        public void onCompletion() {
        }

        public void onException(Exception e) {
        }
    };
    protected final String name;
    protected final String nameWithPrefix;
    protected final CacheConfig<K, V> cacheConfig;
    protected ClientContext clientContext;
    protected ILogger logger;
    private final ConcurrentMap<Future, CompletionListener> loadAllCalls = new ConcurrentHashMap<Future, CompletionListener>();
    private final AtomicBoolean isClosed = new AtomicBoolean(false);
    private final AtomicBoolean isDestroyed = new AtomicBoolean(false);
    private final AtomicInteger completionIdCounter = new AtomicInteger();

    protected AbstractClientCacheProxyBase(CacheConfig<K, V> cacheConfig) {
        super("hz:impl:cacheService", cacheConfig.getName());
        this.name = cacheConfig.getName();
        this.nameWithPrefix = cacheConfig.getNameWithPrefix();
        this.cacheConfig = cacheConfig;
    }

    protected void injectDependencies(Object obj) {
        if (obj instanceof HazelcastInstanceAware) {
            ((HazelcastInstanceAware)obj).setHazelcastInstance(this.clientContext.getHazelcastInstance());
        }
    }

    @Override
    protected void onInitialize() {
        this.clientContext = this.getContext();
        this.logger = this.clientContext.getLoggingService().getLogger(this.getClass());
    }

    @Override
    protected String getDistributedObjectName() {
        return this.cacheConfig.getNameWithPrefix();
    }

    protected int nextCompletionId() {
        return this.completionIdCounter.incrementAndGet();
    }

    protected void ensureOpen() {
        if (this.isClosed()) {
            throw new IllegalStateException("Cache operations can not be performed. The cache closed");
        }
    }

    public void close() {
        if (!this.isClosed.compareAndSet(false, true)) {
            return;
        }
        this.waitOnGoingLoadAllCallsToFinish();
        this.closeListeners();
    }

    private void waitOnGoingLoadAllCallsToFinish() {
        Iterator iterator = this.loadAllCalls.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Future f = (Future)entry.getKey();
            CompletionListener completionListener = (CompletionListener)entry.getValue();
            try {
                f.get(10L, TimeUnit.SECONDS);
            }
            catch (Throwable t) {
                this.logger.finest("Error occurred at loadAll operation execution while waiting it to finish on cache close!", t);
                this.handleFailureOnCompletionListener(completionListener, t);
            }
            iterator.remove();
        }
    }

    @Override
    protected boolean preDestroy() {
        this.close();
        if (!this.isDestroyed.compareAndSet(false, true)) {
            return false;
        }
        this.isClosed.set(true);
        return true;
    }

    public boolean isClosed() {
        return this.isClosed.get();
    }

    public boolean isDestroyed() {
        return this.isDestroyed.get();
    }

    public void open() {
        if (this.isDestroyed.get()) {
            throw new IllegalStateException("Cache is already destroyed! Cannot be reopened");
        }
        this.isClosed.set(false);
    }

    protected abstract void closeListeners();

    public String getPrefixedName() {
        return this.nameWithPrefix;
    }

    @Deprecated
    public String getNameWithPrefix() {
        return this.getPrefixedName();
    }

    @Override
    protected <T> T toObject(Object data) {
        return (T)this.clientContext.getSerializationService().toObject(data);
    }

    @Override
    protected Data toData(Object o) {
        return this.clientContext.getSerializationService().toData(o);
    }

    protected ClientMessage invoke(ClientMessage clientMessage) {
        try {
            ClientInvocationFuture future = new ClientInvocation((HazelcastClientInstanceImpl)this.clientContext.getHazelcastInstance(), clientMessage).invoke();
            return (ClientMessage)future.get();
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    protected ClientMessage invoke(ClientMessage clientMessage, Data keyData) {
        try {
            int partitionId = this.clientContext.getPartitionService().getPartitionId(keyData);
            ClientInvocationFuture future = new ClientInvocation((HazelcastClientInstanceImpl)this.clientContext.getHazelcastInstance(), clientMessage, partitionId).invoke();
            return (ClientMessage)future.get();
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    protected void submitLoadAllTask(ClientMessage request, CompletionListener completionListener, Set<Data> keys) {
        CompletionListener compListener = completionListener != null ? completionListener : NULL_COMPLETION_LISTENER;
        ClientDelegatingFuture delegatingFuture = null;
        try {
            this.injectDependencies(completionListener);
            long start = System.nanoTime();
            ClientInvocationFuture future = new ClientInvocation((HazelcastClientInstanceImpl)this.clientContext.getHazelcastInstance(), request).invoke();
            SerializationService serializationService = this.clientContext.getSerializationService();
            ClientDelegatingFuture delFuture = delegatingFuture = new ClientDelegatingFuture(future, serializationService, LOAD_ALL_DECODER);
            this.loadAllCalls.put((Future)((Object)delegatingFuture), compListener);
            delegatingFuture.andThen(new ExecutionCallback<V>((Future)delFuture, keys, start, compListener){
                final /* synthetic */ Future val$delFuture;
                final /* synthetic */ Set val$keys;
                final /* synthetic */ long val$start;
                final /* synthetic */ CompletionListener val$compListener;
                {
                    this.val$delFuture = future;
                    this.val$keys = set;
                    this.val$start = l;
                    this.val$compListener = completionListener;
                }

                public void onResponse(V response) {
                    AbstractClientCacheProxyBase.this.loadAllCalls.remove(this.val$delFuture);
                    AbstractClientCacheProxyBase.this.onLoadAll(this.val$keys, response, this.val$start, System.nanoTime());
                    this.val$compListener.onCompletion();
                }

                public void onFailure(Throwable t) {
                    AbstractClientCacheProxyBase.this.loadAllCalls.remove(this.val$delFuture);
                    AbstractClientCacheProxyBase.this.handleFailureOnCompletionListener(this.val$compListener, t);
                }
            });
        }
        catch (Throwable t) {
            if (delegatingFuture != null) {
                this.loadAllCalls.remove(delegatingFuture);
            }
            this.handleFailureOnCompletionListener(compListener, t);
        }
    }

    private void handleFailureOnCompletionListener(CompletionListener completionListener, Throwable t) {
        if (t instanceof Exception) {
            Throwable cause = t.getCause();
            if (t instanceof ExecutionException && cause instanceof CacheException) {
                completionListener.onException((Exception)((CacheException)cause));
            } else {
                completionListener.onException((Exception)t);
            }
        } else {
            if (t instanceof OutOfMemoryError) {
                throw ExceptionUtil.rethrow((Throwable)t);
            }
            completionListener.onException((Exception)new CacheException(t));
        }
    }

    protected void onLoadAll(Set<Data> keys, Object response, long start, long end) {
    }
}

