/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.dotnet.shared.plugins;

import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.InputFileFilter;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonarsource.dotnet.shared.plugins.AbstractGlobalProtobufFileProcessor;

public class GeneratedFileFilter
implements InputFileFilter {
    private static final Logger LOG = Loggers.get(GeneratedFileFilter.class);
    private final AbstractGlobalProtobufFileProcessor globalReportProcessor;

    public GeneratedFileFilter(AbstractGlobalProtobufFileProcessor globalReportProcessor) {
        this.globalReportProcessor = globalReportProcessor;
    }

    public boolean accept(InputFile inputFile) {
        boolean isGenerated = this.globalReportProcessor.getGeneratedFilePaths().contains(inputFile.path());
        if (isGenerated) {
            LOG.debug("Skipping auto generated file: {}", (Object)inputFile);
        }
        return !isGenerated;
    }
}

