/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.app;

import javax.annotation.Nullable;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.startup.Tomcat;
import org.sonar.process.Props;

class TomcatConnectors {
    static final String HTTP_PROTOCOL = "HTTP/1.1";
    static final int MAX_HTTP_HEADER_SIZE_BYTES = 49152;
    private static final int MAX_POST_SIZE = -1;

    private TomcatConnectors() {
    }

    static void configure(Tomcat tomcat, Props props) {
        Connector httpConnector = TomcatConnectors.newHttpConnector(props);
        tomcat.getService().addConnector(httpConnector);
    }

    private static Connector newHttpConnector(Props props) {
        int port = props.valueAsInt("sonar.web.port", 9000);
        if (port < 0) {
            throw new IllegalStateException(String.format("HTTP port '%s' is invalid", port));
        }
        Connector connector = new Connector(HTTP_PROTOCOL);
        connector.setURIEncoding("UTF-8");
        connector.setProperty("address", props.value("sonar.web.host", "0.0.0.0"));
        connector.setProperty("socket.soReuseAddress", "true");
        connector.setProperty("relaxedQueryChars", "\"<>[\\]^`{|}");
        TomcatConnectors.configurePool(props, connector);
        TomcatConnectors.configureCompression(connector);
        TomcatConnectors.configureMaxHttpHeaderSize(connector);
        connector.setPort(port);
        connector.setMaxPostSize(-1);
        return connector;
    }

    private static void configureMaxHttpHeaderSize(Connector connector) {
        TomcatConnectors.setConnectorAttribute(connector, "maxHttpHeaderSize", 49152);
    }

    private static void configurePool(Props props, Connector connector) {
        connector.setProperty("acceptorThreadCount", String.valueOf(2));
        connector.setProperty("minSpareThreads", String.valueOf(props.valueAsInt("sonar.web.http.minThreads", 5)));
        connector.setProperty("maxThreads", String.valueOf(props.valueAsInt("sonar.web.http.maxThreads", 50)));
        connector.setProperty("acceptCount", String.valueOf(props.valueAsInt("sonar.web.http.acceptCount", 25)));
    }

    private static void configureCompression(Connector connector) {
        connector.setProperty("compression", "on");
        connector.setProperty("compressionMinSize", "1024");
        connector.setProperty("compressableMimeType", "text/html,text/xml,text/plain,text/css,application/json,application/javascript");
    }

    private static void setConnectorAttribute(Connector c, String key, @Nullable Object value) {
        if (value != null) {
            c.setAttribute(key, value);
        }
    }
}

