/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.authentication;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.sonar.api.platform.Server;
import org.sonar.api.server.authentication.BaseIdentityProvider;
import org.sonar.api.server.authentication.IdentityProvider;
import org.sonar.api.server.authentication.UserIdentity;
import org.sonar.db.user.UserDto;
import org.sonar.server.authentication.JwtHttpHandler;
import org.sonar.server.authentication.UserRegistrar;
import org.sonar.server.authentication.UserRegistration;
import org.sonar.server.authentication.event.AuthenticationEvent;
import org.sonar.server.user.ThreadLocalUserSession;
import org.sonar.server.user.UserSessionFactory;

public class BaseContextFactory {
    private final ThreadLocalUserSession threadLocalUserSession;
    private final UserRegistrar userRegistrar;
    private final Server server;
    private final JwtHttpHandler jwtHttpHandler;
    private final UserSessionFactory userSessionFactory;

    public BaseContextFactory(UserRegistrar userRegistrar, Server server, JwtHttpHandler jwtHttpHandler, ThreadLocalUserSession threadLocalUserSession, UserSessionFactory userSessionFactory) {
        this.userSessionFactory = userSessionFactory;
        this.userRegistrar = userRegistrar;
        this.server = server;
        this.jwtHttpHandler = jwtHttpHandler;
        this.threadLocalUserSession = threadLocalUserSession;
    }

    public BaseIdentityProvider.Context newContext(HttpServletRequest request, HttpServletResponse response, BaseIdentityProvider identityProvider) {
        return new ContextImpl(request, response, identityProvider);
    }

    private class ContextImpl
    implements BaseIdentityProvider.Context {
        private final HttpServletRequest request;
        private final HttpServletResponse response;
        private final BaseIdentityProvider identityProvider;

        public ContextImpl(HttpServletRequest request, HttpServletResponse response, BaseIdentityProvider identityProvider) {
            this.request = request;
            this.response = response;
            this.identityProvider = identityProvider;
        }

        public HttpServletRequest getRequest() {
            return this.request;
        }

        public HttpServletResponse getResponse() {
            return this.response;
        }

        public String getServerBaseURL() {
            return BaseContextFactory.this.server.getPublicRootUrl();
        }

        public void authenticate(UserIdentity userIdentity) {
            UserDto userDto = BaseContextFactory.this.userRegistrar.register(UserRegistration.builder().setUserIdentity(userIdentity).setProvider((IdentityProvider)this.identityProvider).setSource(AuthenticationEvent.Source.external((IdentityProvider)this.identityProvider)).setExistingEmailStrategy(UserRegistration.ExistingEmailStrategy.FORBID).setUpdateLoginStrategy(UserRegistration.UpdateLoginStrategy.ALLOW).build());
            BaseContextFactory.this.jwtHttpHandler.generateToken(userDto, this.request, this.response);
            BaseContextFactory.this.threadLocalUserSession.set(BaseContextFactory.this.userSessionFactory.create(userDto));
        }
    }
}

