/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.authentication;

import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.sonar.api.platform.Server;
import org.sonar.api.server.authentication.IdentityProvider;
import org.sonar.api.server.authentication.OAuth2IdentityProvider;
import org.sonar.api.server.authentication.UnauthorizedException;
import org.sonar.api.web.ServletFilter;
import org.sonar.server.authentication.AuthenticationError;
import org.sonar.server.authentication.AuthenticationFilter;
import org.sonar.server.authentication.AuthenticationRedirection;
import org.sonar.server.authentication.IdentityProviderRepository;
import org.sonar.server.authentication.OAuth2AuthenticationParameters;
import org.sonar.server.authentication.OAuth2ContextFactory;
import org.sonar.server.authentication.event.AuthenticationEvent;
import org.sonar.server.authentication.event.AuthenticationException;
import org.sonar.server.authentication.exception.RedirectionException;
import org.sonar.server.user.ThreadLocalUserSession;

public class OAuth2CallbackFilter
extends AuthenticationFilter {
    private final OAuth2ContextFactory oAuth2ContextFactory;
    private final AuthenticationEvent authenticationEvent;
    private final OAuth2AuthenticationParameters oauth2Parameters;
    private final ThreadLocalUserSession threadLocalUserSession;

    public OAuth2CallbackFilter(IdentityProviderRepository identityProviderRepository, OAuth2ContextFactory oAuth2ContextFactory, Server server, AuthenticationEvent authenticationEvent, OAuth2AuthenticationParameters oauth2Parameters, ThreadLocalUserSession threadLocalUserSession) {
        super(server, identityProviderRepository);
        this.oAuth2ContextFactory = oAuth2ContextFactory;
        this.authenticationEvent = authenticationEvent;
        this.oauth2Parameters = oauth2Parameters;
        this.threadLocalUserSession = threadLocalUserSession;
    }

    public ServletFilter.UrlPattern doGetPattern() {
        return ServletFilter.UrlPattern.create((String)"/oauth2/callback/*");
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        IdentityProvider provider = this.resolveProviderOrHandleResponse(httpRequest, httpResponse, "/oauth2/callback/");
        if (provider != null) {
            this.handleProvider(httpRequest, (HttpServletResponse)response, provider);
        }
    }

    private void handleProvider(HttpServletRequest request, HttpServletResponse response, IdentityProvider provider) {
        try {
            if (provider instanceof OAuth2IdentityProvider) {
                this.handleOAuth2Provider(response, request, (OAuth2IdentityProvider)provider);
            } else {
                AuthenticationError.handleError(response, String.format("Not an OAuth2IdentityProvider: %s", provider.getClass()));
            }
        }
        catch (AuthenticationException e) {
            this.oauth2Parameters.delete(request, response);
            this.authenticationEvent.loginFailure(request, e);
            AuthenticationError.handleAuthenticationError(e, response, this.getContextPath());
        }
        catch (RedirectionException e) {
            this.oauth2Parameters.delete(request, response);
            AuthenticationRedirection.redirectTo(response, e.getPath(this.getContextPath()));
        }
        catch (Exception e) {
            this.oauth2Parameters.delete(request, response);
            AuthenticationError.handleError(e, response, String.format("Fail to callback authentication with '%s'", provider.getKey()));
        }
    }

    private void handleOAuth2Provider(HttpServletResponse response, HttpServletRequest httpRequest, OAuth2IdentityProvider oAuth2Provider) {
        OAuth2IdentityProvider.CallbackContext context = this.oAuth2ContextFactory.newCallback(httpRequest, response, oAuth2Provider);
        try {
            oAuth2Provider.callback(context);
        }
        catch (UnauthorizedException e) {
            throw AuthenticationException.newBuilder().setSource(AuthenticationEvent.Source.oauth2(oAuth2Provider)).setMessage(e.getMessage()).setPublicMessage(e.getMessage()).build();
        }
        if (!this.threadLocalUserSession.hasSession()) {
            throw AuthenticationException.newBuilder().setSource(AuthenticationEvent.Source.oauth2(oAuth2Provider)).setMessage("Plugin did not call authenticate").build();
        }
        this.authenticationEvent.loginSuccess(httpRequest, this.threadLocalUserSession.getLogin(), AuthenticationEvent.Source.oauth2(oAuth2Provider));
    }

    public void init(FilterConfig filterConfig) {
    }

    public void destroy() {
    }
}

