/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.badge.ws;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Resources;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EnumMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.apache.commons.io.IOUtils;
import org.sonar.api.measures.Metric;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.measure.LiveMeasureDto;
import org.sonar.db.metric.MetricDto;
import org.sonar.server.badge.ws.ETagUtils;
import org.sonar.server.badge.ws.ProjectBadgesException;
import org.sonar.server.badge.ws.ProjectBadgesSupport;
import org.sonar.server.badge.ws.ProjectBadgesWsAction;
import org.sonar.server.badge.ws.SvgFormatter;
import org.sonar.server.badge.ws.SvgGenerator;
import org.sonar.server.exceptions.ForbiddenException;
import org.sonar.server.exceptions.NotFoundException;
import org.sonar.server.measure.Rating;

public class MeasureAction
implements ProjectBadgesWsAction {
    private static final String PARAM_METRIC = "metric";
    private static final Map<String, String> METRIC_NAME_BY_KEY = ImmutableMap.builder().put((Object)"bugs", (Object)"bugs").put((Object)"code_smells", (Object)"code smells").put((Object)"coverage", (Object)"coverage").put((Object)"duplicated_lines_density", (Object)"duplicated lines").put((Object)"ncloc", (Object)"lines of code").put((Object)"sqale_rating", (Object)"maintainability").put((Object)"alert_status", (Object)"quality gate").put((Object)"reliability_rating", (Object)"reliability").put((Object)"security_rating", (Object)"security").put((Object)"sqale_index", (Object)"technical debt").put((Object)"vulnerabilities", (Object)"vulnerabilities").build();
    private static final Map<Metric.Level, String> QUALITY_GATE_MESSAGE_BY_STATUS = new EnumMap<Metric.Level, String>((Map<Metric.Level, String>)ImmutableMap.of((Object)Metric.Level.OK, (Object)"passed", (Object)Metric.Level.WARN, (Object)"warning", (Object)Metric.Level.ERROR, (Object)"failed"));
    private static final Map<Metric.Level, SvgGenerator.Color> COLOR_BY_QUALITY_GATE_STATUS = new EnumMap<Metric.Level, SvgGenerator.Color>((Map<Metric.Level, SvgGenerator.Color>)ImmutableMap.of((Object)Metric.Level.OK, (Object)SvgGenerator.Color.QUALITY_GATE_OK, (Object)Metric.Level.WARN, (Object)SvgGenerator.Color.QUALITY_GATE_WARN, (Object)Metric.Level.ERROR, (Object)SvgGenerator.Color.QUALITY_GATE_ERROR));
    private static final Map<Rating, SvgGenerator.Color> COLOR_BY_RATING = new EnumMap<Rating, SvgGenerator.Color>((Map<Rating, SvgGenerator.Color>)ImmutableMap.of((Object)Rating.A, (Object)SvgGenerator.Color.RATING_A, (Object)Rating.B, (Object)SvgGenerator.Color.RATING_B, (Object)Rating.C, (Object)SvgGenerator.Color.RATING_C, (Object)Rating.D, (Object)SvgGenerator.Color.RATING_D, (Object)Rating.E, (Object)SvgGenerator.Color.RATING_E));
    private final DbClient dbClient;
    private final ProjectBadgesSupport support;
    private final SvgGenerator svgGenerator;

    public MeasureAction(DbClient dbClient, ProjectBadgesSupport support, SvgGenerator svgGenerator) {
        this.dbClient = dbClient;
        this.support = support;
        this.svgGenerator = svgGenerator;
    }

    public void define(WebService.NewController controller) {
        WebService.NewAction action = controller.createAction("measure").setHandler((RequestHandler)this).setDescription("Generate badge for project's measure as an SVG.<br/>Requires 'Browse' permission on the specified project.").setSince("7.1").setResponseExample(Resources.getResource(this.getClass(), (String)"measure-example.svg"));
        this.support.addProjectAndBranchParams(action);
        action.createParam(PARAM_METRIC).setDescription("Metric key").setRequired(true).setPossibleValues(METRIC_NAME_BY_KEY.keySet());
    }

    public void handle(Request request, Response response) throws Exception {
        response.setHeader("Cache-Control", "no-cache");
        response.stream().setMediaType("image/svg+xml");
        String metricKey = request.mandatoryParam(PARAM_METRIC);
        try (DbSession dbSession = this.dbClient.openSession(false);){
            ComponentDto project = this.support.getComponent(dbSession, request);
            MetricDto metric = this.dbClient.metricDao().selectByKey(dbSession, metricKey);
            Preconditions.checkState((metric != null && metric.isEnabled() ? 1 : 0) != 0, (String)"Metric '%s' hasn't been found", (Object[])new Object[]{metricKey});
            LiveMeasureDto measure = this.getMeasure(dbSession, project, metricKey);
            String result = this.generateSvg(metric, measure);
            String eTag = ETagUtils.getETag(result);
            Optional requestedETag = request.header("If-None-Match");
            if (requestedETag.filter(eTag::equals).isPresent()) {
                response.stream().setStatus(304);
                return;
            }
            response.setHeader("ETag", eTag);
            IOUtils.write((String)result, (OutputStream)response.stream().output(), (Charset)StandardCharsets.UTF_8);
        }
        catch (ProjectBadgesException | ForbiddenException | NotFoundException e) {
            SimpleDateFormat sdf = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
            response.setHeader("Expires", sdf.format(new Date()));
            IOUtils.write((String)this.svgGenerator.generateError(e.getMessage()), (OutputStream)response.stream().output(), (Charset)StandardCharsets.UTF_8);
        }
    }

    private LiveMeasureDto getMeasure(DbSession dbSession, ComponentDto project, String metricKey) {
        return (LiveMeasureDto)this.dbClient.liveMeasureDao().selectMeasure(dbSession, project.uuid(), metricKey).orElseThrow(() -> new ProjectBadgesException("Measure has not been found"));
    }

    private String generateSvg(MetricDto metric, LiveMeasureDto measure) {
        String metricType = metric.getValueType();
        switch (Metric.ValueType.valueOf((String)metricType)) {
            case INT: {
                return this.generateBadge(metric, SvgFormatter.formatNumeric(MeasureAction.getNonNullValue(measure, LiveMeasureDto::getValue).longValue()), SvgGenerator.Color.DEFAULT);
            }
            case PERCENT: {
                return this.generateBadge(metric, SvgFormatter.formatPercent(MeasureAction.getNonNullValue(measure, LiveMeasureDto::getValue)), SvgGenerator.Color.DEFAULT);
            }
            case LEVEL: {
                return this.generateQualityGate(metric, measure);
            }
            case WORK_DUR: {
                return this.generateBadge(metric, SvgFormatter.formatDuration(MeasureAction.getNonNullValue(measure, LiveMeasureDto::getValue).longValue()), SvgGenerator.Color.DEFAULT);
            }
            case RATING: {
                return this.generateRating(metric, measure);
            }
        }
        throw new IllegalStateException(String.format("Invalid metric type '%s'", metricType));
    }

    private String generateQualityGate(MetricDto metric, LiveMeasureDto measure) {
        Metric.Level qualityGate = Metric.Level.valueOf((String)MeasureAction.getNonNullValue(measure, LiveMeasureDto::getTextValue));
        return this.generateBadge(metric, QUALITY_GATE_MESSAGE_BY_STATUS.get(qualityGate), COLOR_BY_QUALITY_GATE_STATUS.get(qualityGate));
    }

    private String generateRating(MetricDto metric, LiveMeasureDto measure) {
        Rating rating = Rating.valueOf((int)MeasureAction.getNonNullValue(measure, LiveMeasureDto::getValue).intValue());
        return this.generateBadge(metric, rating.name(), COLOR_BY_RATING.get(rating));
    }

    private String generateBadge(MetricDto metric, String value, SvgGenerator.Color color) {
        return this.svgGenerator.generateBadge(METRIC_NAME_BY_KEY.get(metric.getKey()), value, color);
    }

    private static <PARAM> PARAM getNonNullValue(LiveMeasureDto measure, Function<LiveMeasureDto, PARAM> function) {
        PARAM value = function.apply(measure);
        Preconditions.checkState((value != null ? 1 : 0) != 0, (Object)"Measure has not been found");
        return value;
    }
}

