/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.badge.ws;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;

class SvgFormatter {
    private static final String ZERO = "0";
    private static final String NUMERIC_SUFFIX_LIST = " kmbt";
    private static final String NUMERIC_REGEXP = "\\.[0-9]+";
    private static final String DURATION_MINUTES_FORMAT = "%smin";
    private static final String DURATION_HOURS_FORMAT = "%sh";
    private static final String DURATION_DAYS_FORMAT = "%sd";
    private static final int DURATION_HOURS_IN_DAY = 8;
    private static final double DURATION_ALMOST_ONE = 0.9;
    private static final int DURATION_OF_ONE_HOUR_IN_MINUTES = 60;

    private SvgFormatter() {
    }

    static String formatNumeric(long value) {
        if (value == 0L) {
            return ZERO;
        }
        NumberFormat numericFormatter = DecimalFormat.getInstance(Locale.ENGLISH);
        numericFormatter.setMaximumFractionDigits(1);
        int power = (int)StrictMath.log10(value);
        double valueToFormat = (double)value / Math.pow(10.0, (double)Math.floorDiv(power, 3) * 3.0);
        String formattedNumber = numericFormatter.format(valueToFormat);
        formattedNumber = formattedNumber + NUMERIC_SUFFIX_LIST.charAt(power / 3);
        return formattedNumber.length() > 4 ? StringUtils.trim((String)formattedNumber.replaceAll(NUMERIC_REGEXP, "")) : StringUtils.trim((String)formattedNumber);
    }

    static String formatPercent(double value) {
        DecimalFormat percentFormatter = new DecimalFormat("#.#", DecimalFormatSymbols.getInstance(Locale.ENGLISH));
        return percentFormatter.format(value) + "%";
    }

    static String formatDuration(long durationInMinutes) {
        if (durationInMinutes == 0L) {
            return ZERO;
        }
        double days = (double)durationInMinutes / 8.0 / 60.0;
        if (days > 0.9) {
            return String.format(DURATION_DAYS_FORMAT, Math.round(days));
        }
        double remainingDuration = (double)durationInMinutes - Math.floor(days) * 8.0 * 60.0;
        double hours = remainingDuration / 60.0;
        if (hours > 0.9) {
            return String.format(DURATION_HOURS_FORMAT, Math.round(hours));
        }
        double minutes = remainingDuration - Math.floor(hours) * 60.0;
        return String.format(DURATION_MINUTES_FORMAT, Math.round(minutes));
    }
}

