/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.branch.ws;

import java.util.Collections;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.BranchDto;
import org.sonar.db.component.ComponentDto;
import org.sonar.server.branch.ws.BranchWsAction;
import org.sonar.server.branch.ws.BranchesWs;
import org.sonar.server.component.ComponentCleanerService;
import org.sonar.server.component.ComponentFinder;
import org.sonar.server.project.Project;
import org.sonar.server.project.ProjectLifeCycleListeners;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.WsUtils;

public class DeleteAction
implements BranchWsAction {
    private final DbClient dbClient;
    private final UserSession userSession;
    private final ComponentCleanerService componentCleanerService;
    private final ComponentFinder componentFinder;
    private final ProjectLifeCycleListeners projectLifeCycleListeners;

    public DeleteAction(DbClient dbClient, ComponentFinder componentFinder, UserSession userSession, ComponentCleanerService componentCleanerService, ProjectLifeCycleListeners projectLifeCycleListeners) {
        this.dbClient = dbClient;
        this.componentFinder = componentFinder;
        this.userSession = userSession;
        this.componentCleanerService = componentCleanerService;
        this.projectLifeCycleListeners = projectLifeCycleListeners;
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction("delete").setSince("6.6").setDescription("Delete a non-main branch of a project.<br/>Requires 'Administer' rights on the specified project.").setPost(true).setHandler((RequestHandler)this);
        BranchesWs.addProjectParam(action);
        BranchesWs.addBranchParam(action);
    }

    public void handle(Request request, Response response) throws Exception {
        this.userSession.checkLoggedIn();
        String projectKey = request.mandatoryParam("project");
        String branchKey = request.mandatoryParam("branch");
        try (DbSession dbSession = this.dbClient.openSession(false);){
            ComponentDto project = this.componentFinder.getRootComponentByUuidOrKey(dbSession, null, projectKey);
            this.checkPermission(project);
            BranchDto branch = (BranchDto)WsUtils.checkFoundWithOptional(this.dbClient.branchDao().selectByBranchKey(dbSession, project.uuid(), branchKey), "Branch '%s' not found for project '%s'", branchKey, projectKey);
            if (branch.isMain()) {
                throw new IllegalArgumentException("Only non-main branches can be deleted");
            }
            ComponentDto branchComponent = this.componentFinder.getByKeyAndBranch(dbSession, projectKey, branchKey);
            this.componentCleanerService.deleteBranch(dbSession, branchComponent);
            this.projectLifeCycleListeners.onProjectBranchesDeleted(Collections.singleton(Project.from((ComponentDto)project)));
            response.noContent();
        }
    }

    private void checkPermission(ComponentDto project) {
        this.userSession.checkComponentPermission("admin", project);
    }
}

