/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.ce.queue;

import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.sonar.api.server.ServerSide;
import org.sonar.core.component.ComponentKeys;
import org.sonar.db.DbSession;
import org.sonar.db.component.BranchDto;
import org.sonar.db.component.BranchType;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.server.ce.queue.BranchSupportDelegate;

@ServerSide
public class BranchSupport {
    @CheckForNull
    private final BranchSupportDelegate delegate;

    public BranchSupport() {
        this(null);
    }

    public BranchSupport(@Nullable BranchSupportDelegate delegate) {
        this.delegate = delegate;
    }

    ComponentKey createComponentKey(String projectKey, @Nullable String deprecatedBranch, Map<String, String> characteristics) {
        if (characteristics.isEmpty()) {
            return new ComponentKeyImpl(projectKey, deprecatedBranch, ComponentKeys.createKey((String)projectKey, (String)deprecatedBranch));
        }
        Preconditions.checkState((this.delegate != null ? 1 : 0) != 0, (Object)"Current edition does not support branch feature");
        Preconditions.checkArgument((deprecatedBranch == null ? 1 : 0) != 0, (Object)"Deprecated branch feature can't be used at the same time as new branch support");
        return this.delegate.createComponentKey(projectKey, characteristics);
    }

    ComponentDto createBranchComponent(DbSession dbSession, ComponentKey componentKey, OrganizationDto organization, ComponentDto mainComponentDto, BranchDto mainComponentBranchDto) {
        Preconditions.checkState((this.delegate != null ? 1 : 0) != 0, (Object)"Current edition does not support branch feature");
        return this.delegate.createBranchComponent(dbSession, componentKey, organization, mainComponentDto, mainComponentBranchDto);
    }

    private static final class ComponentKeyImpl
    extends ComponentKey {
        private final String key;
        private final String dbKey;
        @CheckForNull
        private final String deprecatedBranchName;

        public ComponentKeyImpl(String key, @Nullable String deprecatedBranchName, String dbKey) {
            this.key = key;
            this.deprecatedBranchName = deprecatedBranchName;
            this.dbKey = dbKey;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public String getDbKey() {
            return this.dbKey;
        }

        @Override
        public Optional<String> getDeprecatedBranchName() {
            return Optional.ofNullable(this.deprecatedBranchName);
        }

        @Override
        public Optional<Branch> getBranch() {
            return Optional.empty();
        }

        @Override
        public Optional<String> getPullRequestKey() {
            return Optional.empty();
        }

        @Override
        public ComponentKey getMainBranchComponentKey() {
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ComponentKeyImpl that = (ComponentKeyImpl)o;
            return Objects.equals(this.key, that.key) && Objects.equals(this.dbKey, that.dbKey) && Objects.equals(this.deprecatedBranchName, that.deprecatedBranchName);
        }

        public int hashCode() {
            return Objects.hash(this.key, this.dbKey, this.deprecatedBranchName);
        }
    }

    @Immutable
    public static final class Branch {
        private final String name;
        private final BranchType type;

        public Branch(String name, BranchType type) {
            this.name = Objects.requireNonNull(name, "name can't be null");
            this.type = Objects.requireNonNull(type, "type can't be null");
        }

        public String getName() {
            return this.name;
        }

        public BranchType getType() {
            return this.type;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Branch branch = (Branch)o;
            return this.name.equals(branch.name) && this.type == branch.type;
        }

        public int hashCode() {
            return Objects.hash(this.name, this.type);
        }

        public String toString() {
            return "Branch{name='" + this.name + '\'' + ", type=" + this.type + '}';
        }
    }

    public static abstract class ComponentKey {
        public abstract String getKey();

        public abstract String getDbKey();

        public abstract Optional<String> getDeprecatedBranchName();

        public abstract Optional<Branch> getBranch();

        public abstract Optional<String> getPullRequestKey();

        public final boolean isDeprecatedBranch() {
            return this.getDeprecatedBranchName().isPresent();
        }

        public final boolean isMainBranch() {
            return !this.getBranch().isPresent() && !this.getPullRequestKey().isPresent();
        }

        public abstract ComponentKey getMainBranchComponentKey();
    }
}

