/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.ce.ws;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.protobuf.Message;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.server.ws.Change;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.DateUtils;
import org.sonar.ce.task.taskprocessor.CeTaskProcessor;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.Pagination;
import org.sonar.db.ce.CeActivityDto;
import org.sonar.db.ce.CeQueueDto;
import org.sonar.db.ce.CeTaskQuery;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.component.ComponentQuery;
import org.sonar.server.ce.ws.CeWsAction;
import org.sonar.server.ce.ws.TaskFormatter;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.Ce;

public class ActivityAction
implements CeWsAction {
    private static final int MAX_PAGE_SIZE = 1000;
    private static final String[] POSSIBLE_QUALIFIERS = new String[]{"TRK", "APP", "VW"};
    private final UserSession userSession;
    private final DbClient dbClient;
    private final TaskFormatter formatter;
    private final Set<String> taskTypes;

    public ActivityAction(UserSession userSession, DbClient dbClient, TaskFormatter formatter, CeTaskProcessor[] taskProcessors) {
        this.userSession = userSession;
        this.dbClient = dbClient;
        this.formatter = formatter;
        this.taskTypes = new LinkedHashSet<String>();
        for (CeTaskProcessor taskProcessor : taskProcessors) {
            this.taskTypes.addAll(taskProcessor.getHandledCeTaskTypes());
        }
    }

    @Override
    public void define(WebService.NewController controller) {
        WebService.NewAction action = controller.createAction("activity").setDescription(String.format("Search for tasks.<br> Requires the system administration permission, or project administration permission if %s is set.", "componentId")).setResponseExample(this.getClass().getResource("activity-example.json")).setHandler((RequestHandler)this).setChangelog(new Change[]{new Change("5.5", "it's no more possible to specify the page parameter."), new Change("6.1", "field \"logs\" is deprecated and its value is always false"), new Change("6.6", "fields \"branch\" and \"branchType\" added"), new Change("7.1", "field \"pullRequest\" added"), new Change("7.6", String.format("The use of module keys in parameters '%s' and '%s' is deprecated", "q", "componentQuery"))}).setSince("5.2");
        action.createParam("componentId").setDescription("Id of the component (project) to filter on").setExampleValue((Object)"AU-TpxcA-iU5OvuD2FL0");
        action.createParam("componentQuery").setDescription(String.format("Limit search to: <ul><li>component names that contain the supplied string</li><li>component keys that are exactly the same as the supplied string</li></ul>Must not be set together with %s.<br />Deprecated and replaced by '%s'", "componentId", "q")).setExampleValue((Object)"Apache").setDeprecatedSince("5.5");
        action.createParam("q").setDescription(String.format("Limit search to: <ul><li>component names that contain the supplied string</li><li>component keys that are exactly the same as the supplied string</li><li>task ids that are exactly the same as the supplied string</li></ul>Must not be set together with %s", "componentId")).setExampleValue((Object)"Apache").setSince("5.5");
        action.createParam("status").setDescription("Comma separated list of task statuses").setPossibleValues((Collection)ImmutableList.builder().addAll(Arrays.asList(CeActivityDto.Status.values())).addAll(Arrays.asList(CeQueueDto.Status.values())).build()).setExampleValue((Object)Joiner.on((String)",").join((Object)CeQueueDto.Status.IN_PROGRESS, (Object)CeActivityDto.Status.SUCCESS, new Object[0])).setDefaultValue((Object)Joiner.on((String)",").join((Object[])CeActivityDto.Status.values()));
        action.createParam("onlyCurrents").setDescription("Filter on the last tasks (only the most recent finished task by project)").setBooleanPossibleValues().setDefaultValue((Object)"false");
        action.createParam("type").setDescription("Task type").setExampleValue((Object)"REPORT").setPossibleValues(this.taskTypes);
        action.createParam("minSubmittedAt").setDescription("Minimum date of task submission (inclusive)").setExampleValue((Object)"2017-10-19T13:00:00+0200");
        action.createParam("maxExecutedAt").setDescription("Maximum date of end of task processing (inclusive)").setExampleValue((Object)"2017-10-19T13:00:00+0200");
        action.createParam("p").setDescription("Deprecated parameter").setDeprecatedSince("5.5").setDeprecatedKey("pageIndex", "5.4");
        action.createPageSize(100, 1000);
    }

    public void handle(org.sonar.api.server.ws.Request wsRequest, Response wsResponse) throws Exception {
        Ce.ActivityResponse activityResponse = this.doHandle(ActivityAction.toSearchWsRequest(wsRequest));
        WsUtils.writeProtobuf((Message)activityResponse, wsRequest, wsResponse);
    }

    private Ce.ActivityResponse doHandle(Request request) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            ComponentDto component = this.loadComponent(dbSession, request);
            this.checkPermission(component);
            Optional<Ce.Task> taskSearchedById = this.searchTaskByUuid(dbSession, request);
            if (taskSearchedById.isPresent()) {
                Ce.ActivityResponse activityResponse = ActivityAction.buildResponse(Collections.singletonList(taskSearchedById.get()), Collections.emptyList(), Integer.parseInt(request.getPs()));
                return activityResponse;
            }
            CeTaskQuery query = this.buildQuery(dbSession, request, component);
            List<Ce.Task> queuedTasks = this.loadQueuedTasks(dbSession, request, query);
            List<Ce.Task> pastTasks = this.loadPastTasks(dbSession, request, query);
            Ce.ActivityResponse activityResponse = ActivityAction.buildResponse(queuedTasks, pastTasks, Integer.parseInt(request.getPs()));
            return activityResponse;
        }
    }

    @CheckForNull
    private ComponentDto loadComponent(DbSession dbSession, Request request) {
        String componentId = request.getComponentId();
        if (componentId == null) {
            return null;
        }
        return (ComponentDto)WsUtils.checkFoundWithOptional(this.dbClient.componentDao().selectByUuid(dbSession, componentId), "Component '%s' does not exist", componentId);
    }

    private void checkPermission(@Nullable ComponentDto component) {
        this.userSession.checkLoggedIn();
        if (component == null) {
            this.userSession.checkIsSystemAdministrator();
        } else {
            this.userSession.checkComponentPermission("admin", component);
        }
    }

    private Optional<Ce.Task> searchTaskByUuid(DbSession dbSession, Request request) {
        String textQuery = request.getQ();
        if (textQuery == null) {
            return Optional.empty();
        }
        Optional queue = this.dbClient.ceQueueDao().selectByUuid(dbSession, textQuery);
        if (queue.isPresent()) {
            return Optional.of(this.formatter.formatQueue(dbSession, (CeQueueDto)queue.get()));
        }
        Optional activity = this.dbClient.ceActivityDao().selectByUuid(dbSession, textQuery);
        return activity.map(ceActivityDto -> this.formatter.formatActivity(dbSession, (CeActivityDto)ceActivityDto, null, Collections.emptyList()));
    }

    private CeTaskQuery buildQuery(DbSession dbSession, Request request, @Nullable ComponentDto component) {
        CeTaskQuery query = new CeTaskQuery();
        query.setType(request.getType());
        query.setOnlyCurrents(Boolean.parseBoolean(request.getOnlyCurrents()));
        Date minSubmittedAt = DateUtils.parseStartingDateOrDateTime((String)request.getMinSubmittedAt());
        query.setMinSubmittedAt(minSubmittedAt == null ? null : Long.valueOf(minSubmittedAt.getTime()));
        Date maxExecutedAt = DateUtils.parseEndingDateOrDateTime((String)request.getMaxExecutedAt());
        query.setMaxExecutedAt(maxExecutedAt == null ? null : Long.valueOf(maxExecutedAt.getTime()));
        List statuses = request.getStatus();
        if (statuses != null && !statuses.isEmpty()) {
            query.setStatuses(request.getStatus());
        }
        String componentQuery = request.getQ();
        if (component != null) {
            query.setMainComponentUuid(component.uuid());
        } else if (componentQuery != null) {
            query.setMainComponentUuids((List)this.loadComponents(dbSession, componentQuery).stream().map(ComponentDto::uuid).collect(MoreCollectors.toList()));
        }
        return query;
    }

    private List<ComponentDto> loadComponents(DbSession dbSession, String componentQuery) {
        ComponentQuery componentDtoQuery = ComponentQuery.builder().setNameOrKeyQuery(componentQuery).setQualifiers(POSSIBLE_QUALIFIERS).build();
        return this.dbClient.componentDao().selectByQuery(dbSession, componentDtoQuery, 0, 1000);
    }

    private List<Ce.Task> loadQueuedTasks(DbSession dbSession, Request request, CeTaskQuery query) {
        List dtos = this.dbClient.ceQueueDao().selectByQueryInDescOrder(dbSession, query, Integer.parseInt(request.getPs()));
        return this.formatter.formatQueue(dbSession, dtos);
    }

    private List<Ce.Task> loadPastTasks(DbSession dbSession, Request request, CeTaskQuery query) {
        List dtos = this.dbClient.ceActivityDao().selectByQuery(dbSession, query, Pagination.forPage((int)1).andSize(Integer.parseInt(request.getPs())));
        return this.formatter.formatActivity(dbSession, dtos);
    }

    private static Ce.ActivityResponse buildResponse(Iterable<Ce.Task> queuedTasks, Iterable<Ce.Task> pastTasks, int pageSize) {
        Ce.ActivityResponse.Builder wsResponseBuilder = Ce.ActivityResponse.newBuilder();
        int nbInsertedTasks = 0;
        for (Ce.Task queuedTask : queuedTasks) {
            if (nbInsertedTasks >= pageSize) continue;
            wsResponseBuilder.addTasks(queuedTask);
            ++nbInsertedTasks;
        }
        for (Ce.Task pastTask : pastTasks) {
            if (nbInsertedTasks >= pageSize) continue;
            wsResponseBuilder.addTasks(pastTask);
            ++nbInsertedTasks;
        }
        return wsResponseBuilder.build();
    }

    private static Request toSearchWsRequest(org.sonar.api.server.ws.Request request) {
        Request activityWsRequest = new Request().setComponentId(request.param("componentId")).setQ(StringUtils.defaultString((String)request.param("q"), (String)request.param("componentQuery"))).setStatus(request.paramAsStrings("status")).setType(request.param("type")).setMinSubmittedAt(request.param("minSubmittedAt")).setMaxExecutedAt(request.param("maxExecutedAt")).setOnlyCurrents(String.valueOf(request.paramAsBoolean("onlyCurrents"))).setPs(String.valueOf(request.mandatoryParamAsInt("ps")));
        WsUtils.checkRequest(activityWsRequest.getComponentId() == null || activityWsRequest.getQ() == null, "%s and %s must not be set at the same time", "componentId", "componentQuery");
        return activityWsRequest;
    }

    private static class Request {
        private String componentId;
        private String maxExecutedAt;
        private String minSubmittedAt;
        private String onlyCurrents;
        private String ps;
        private String q;
        private List<String> status;
        private String type;

        private Request() {
        }

        private Request setComponentId(String componentId) {
            this.componentId = componentId;
            return this;
        }

        private String getComponentId() {
            return this.componentId;
        }

        private Request setMaxExecutedAt(String maxExecutedAt) {
            this.maxExecutedAt = maxExecutedAt;
            return this;
        }

        private String getMaxExecutedAt() {
            return this.maxExecutedAt;
        }

        private Request setMinSubmittedAt(String minSubmittedAt) {
            this.minSubmittedAt = minSubmittedAt;
            return this;
        }

        private String getMinSubmittedAt() {
            return this.minSubmittedAt;
        }

        private Request setOnlyCurrents(String onlyCurrents) {
            this.onlyCurrents = onlyCurrents;
            return this;
        }

        private String getOnlyCurrents() {
            return this.onlyCurrents;
        }

        private Request setPs(String ps) {
            this.ps = ps;
            return this;
        }

        private String getPs() {
            return this.ps;
        }

        private Request setQ(String q) {
            this.q = q;
            return this;
        }

        private String getQ() {
            return this.q;
        }

        private Request setStatus(List<String> status) {
            this.status = status;
            return this;
        }

        private List<String> getStatus() {
            return this.status;
        }

        private Request setType(String type) {
            this.type = type;
            return this;
        }

        private String getType() {
            return this.type;
        }
    }
}

