/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.component.ws;

import com.google.common.base.Preconditions;
import com.google.protobuf.Message;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.i18n.I18n;
import org.sonar.api.resources.Languages;
import org.sonar.api.resources.ResourceTypes;
import org.sonar.api.server.ws.Change;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.Paging;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.server.component.index.ComponentIndex;
import org.sonar.server.component.index.ComponentQuery;
import org.sonar.server.component.ws.ComponentsWsAction;
import org.sonar.server.es.SearchIdResult;
import org.sonar.server.es.SearchOptions;
import org.sonar.server.organization.DefaultOrganization;
import org.sonar.server.organization.DefaultOrganizationProvider;
import org.sonar.server.util.LanguageParamUtils;
import org.sonar.server.ws.WsParameterBuilder;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.Components;

public class SearchAction
implements ComponentsWsAction {
    private final ComponentIndex componentIndex;
    private final DbClient dbClient;
    private final ResourceTypes resourceTypes;
    private final I18n i18n;
    private final Languages languages;
    private final DefaultOrganizationProvider defaultOrganizationProvider;

    public SearchAction(ComponentIndex componentIndex, DbClient dbClient, ResourceTypes resourceTypes, I18n i18n, Languages languages, DefaultOrganizationProvider defaultOrganizationProvider) {
        this.componentIndex = componentIndex;
        this.dbClient = dbClient;
        this.resourceTypes = resourceTypes;
        this.i18n = i18n;
        this.languages = languages;
        this.defaultOrganizationProvider = defaultOrganizationProvider;
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction("search").setSince("6.3").setDescription("Search for components").addPagingParams(100, 500).setChangelog(new Change[]{new Change("7.6", String.format("The use of 'BRC' as value for parameter '%s' is deprecated", "qualifiers"))}).setResponseExample(this.getClass().getResource("search-components-example.json")).setHandler((RequestHandler)this);
        action.createParam("q").setDescription("Limit search to: <ul><li>component names that contain the supplied string</li><li>component keys that are exactly the same as the supplied string</li></ul>").setExampleValue((Object)"sonar");
        action.createParam("organization").setDescription("Organization key").setRequired(false).setInternal(true).setExampleValue((Object)"my-org").setSince("6.3");
        action.createParam("language").setDescription("Language key. If provided, only components for the given language are returned.").setExampleValue((Object)LanguageParamUtils.getExampleValue(this.languages)).setPossibleValues(LanguageParamUtils.getOrderedLanguageKeys(this.languages));
        WsParameterBuilder.createQualifiersParameter(action, WsParameterBuilder.QualifierParameterContext.newQualifierParameterContext(this.i18n, this.resourceTypes)).setRequired(true);
    }

    public void handle(Request wsRequest, Response wsResponse) throws Exception {
        Components.SearchWsResponse searchWsResponse = this.doHandle(SearchAction.toSearchWsRequest(wsRequest));
        WsUtils.writeProtobuf((Message)searchWsResponse, wsRequest, wsResponse);
    }

    private static SearchRequest toSearchWsRequest(Request request) {
        return new SearchRequest().setOrganization(request.param("organization")).setQualifiers(request.mandatoryParamAsStrings("qualifiers")).setLanguage(request.param("language")).setQuery(request.param("q")).setPage(request.mandatoryParamAsInt("p")).setPageSize(request.mandatoryParamAsInt("ps"));
    }

    private Components.SearchWsResponse doHandle(SearchRequest request) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            OrganizationDto organization = this.getOrganization(dbSession, request);
            ComponentQuery esQuery = SearchAction.buildEsQuery(organization, request);
            SearchIdResult<String> results = this.componentIndex.search(esQuery, new SearchOptions().setPage(request.getPage().intValue(), request.getPageSize().intValue()));
            List components = this.dbClient.componentDao().selectByUuids(dbSession, (Collection)results.getIds());
            Map<String, String> projectKeysByUuids = this.searchProjectsKeysByUuids(dbSession, components);
            Components.SearchWsResponse searchWsResponse = SearchAction.buildResponse(components, organization, projectKeysByUuids, Paging.forPageIndex((int)request.getPage()).withPageSize(request.getPageSize().intValue()).andTotal((int)results.getTotal()));
            return searchWsResponse;
        }
    }

    private Map<String, String> searchProjectsKeysByUuids(DbSession dbSession, List<ComponentDto> components) {
        Set projectUuidsToSearch = (Set)components.stream().map(ComponentDto::projectUuid).collect(MoreCollectors.toHashSet());
        List projects = this.dbClient.componentDao().selectByUuids(dbSession, (Collection)projectUuidsToSearch).stream().filter(c -> !c.qualifier().equals("BRC")).collect(Collectors.toList());
        return projects.stream().collect(Collectors.toMap(ComponentDto::uuid, ComponentDto::getDbKey));
    }

    private OrganizationDto getOrganization(DbSession dbSession, SearchRequest request) {
        String organizationKey = Optional.ofNullable(request.getOrganization()).orElseGet(() -> ((DefaultOrganization)this.defaultOrganizationProvider.get()).getKey());
        return (OrganizationDto)WsUtils.checkFoundWithOptional(this.dbClient.organizationDao().selectByKey(dbSession, organizationKey), "No organizationDto with key '%s'", organizationKey);
    }

    private static ComponentQuery buildEsQuery(OrganizationDto organization, SearchRequest request) {
        return ComponentQuery.builder().setQuery(request.getQuery()).setOrganization(organization.getUuid()).setLanguage(request.getLanguage()).setQualifiers(request.getQualifiers()).build();
    }

    private static Components.SearchWsResponse buildResponse(List<ComponentDto> components, OrganizationDto organization, Map<String, String> projectKeysByUuids, Paging paging) {
        Components.SearchWsResponse.Builder responseBuilder = Components.SearchWsResponse.newBuilder();
        responseBuilder.getPagingBuilder().setPageIndex(paging.pageIndex()).setPageSize(paging.pageSize()).setTotal(paging.total()).build();
        components.stream().map(dto -> SearchAction.dtoToComponent(organization, dto, (String)projectKeysByUuids.get(dto.projectUuid()))).forEach(arg_0 -> ((Components.SearchWsResponse.Builder)responseBuilder).addComponents(arg_0));
        return responseBuilder.build();
    }

    private static Components.Component dtoToComponent(OrganizationDto organization, ComponentDto dto, String projectKey) {
        Preconditions.checkArgument((boolean)organization.getUuid().equals(dto.getOrganizationUuid()), (String)"No Organization found for uuid '%s'", (Object[])new Object[]{dto.getOrganizationUuid()});
        Components.Component.Builder builder = Components.Component.newBuilder().setOrganization(organization.getKey()).setId(dto.uuid()).setKey(dto.getDbKey()).setProject(projectKey).setName(dto.name()).setQualifier(dto.qualifier());
        Optional.ofNullable(dto.language()).ifPresent(arg_0 -> ((Components.Component.Builder)builder).setLanguage(arg_0));
        return builder.build();
    }

    static class SearchRequest {
        private String organization;
        private List<String> qualifiers;
        private Integer page;
        private Integer pageSize;
        private String query;
        private String language;

        SearchRequest() {
        }

        @CheckForNull
        public String getOrganization() {
            return this.organization;
        }

        public SearchRequest setOrganization(@Nullable String organization) {
            this.organization = organization;
            return this;
        }

        public List<String> getQualifiers() {
            return this.qualifiers;
        }

        public SearchRequest setQualifiers(List<String> qualifiers) {
            this.qualifiers = Objects.requireNonNull(qualifiers);
            return this;
        }

        @CheckForNull
        public Integer getPage() {
            return this.page;
        }

        public SearchRequest setPage(int page) {
            this.page = page;
            return this;
        }

        @CheckForNull
        public Integer getPageSize() {
            return this.pageSize;
        }

        public SearchRequest setPageSize(int pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        @CheckForNull
        public String getQuery() {
            return this.query;
        }

        public SearchRequest setQuery(@Nullable String query) {
            this.query = query;
            return this;
        }

        @CheckForNull
        public String getLanguage() {
            return this.language;
        }

        public SearchRequest setLanguage(@Nullable String language) {
            this.language = language;
            return this;
        }
    }
}

