/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.es;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.unit.TimeValue;
import org.sonar.api.config.Configuration;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.api.utils.log.Profiler;
import org.sonar.server.es.EsClient;
import org.sonar.server.es.IndexType;
import org.sonar.server.es.StartupIndexer;
import org.sonar.server.es.metadata.MetadataIndex;

public class IndexerStartupTask {
    private static final Logger LOG = Loggers.get(IndexerStartupTask.class);
    private final EsClient esClient;
    private final Configuration config;
    private final MetadataIndex metadataIndex;
    private final StartupIndexer[] indexers;

    public IndexerStartupTask(EsClient esClient, Configuration config, MetadataIndex metadataIndex, StartupIndexer ... indexers) {
        this.esClient = esClient;
        this.config = config;
        this.metadataIndex = metadataIndex;
        this.indexers = indexers;
    }

    public void execute() {
        if (this.indexesAreEnabled()) {
            Arrays.stream(this.indexers).forEach(this::indexUninitializedTypes);
        }
    }

    private boolean indexesAreEnabled() {
        return this.config.getBoolean("sonar.internal.es.disableIndexes").orElse(false) == false;
    }

    private void indexUninitializedTypes(StartupIndexer indexer) {
        Set<IndexType> uninitializedTypes = this.getUninitializedTypes(indexer);
        if (!uninitializedTypes.isEmpty()) {
            Profiler profiler = Profiler.create((Logger)LOG);
            profiler.startInfo(this.getLogMessage(uninitializedTypes, "..."));
            indexer.indexOnStartup(uninitializedTypes);
            uninitializedTypes.forEach(this::setInitialized);
            profiler.stopInfo(this.getLogMessage(uninitializedTypes, "done"));
        }
    }

    private Set<IndexType> getUninitializedTypes(StartupIndexer indexer) {
        return indexer.getIndexTypes().stream().filter(indexType -> !this.metadataIndex.getInitialized(indexType)).collect(Collectors.toSet());
    }

    private void setInitialized(IndexType indexType) {
        this.waitForIndexYellow(indexType.getMainType().getIndex().getName());
        this.metadataIndex.setInitialized(indexType, true);
    }

    private void waitForIndexYellow(String index) {
        Client nativeClient = this.esClient.nativeClient();
        ClusterHealthAction.INSTANCE.newRequestBuilder((ElasticsearchClient)nativeClient).setIndices(new String[]{index}).setWaitForYellowStatus().get(TimeValue.timeValueMinutes((long)10L));
    }

    private String getLogMessage(Set<IndexType> emptyTypes, String suffix) {
        String s = emptyTypes.size() == 1 ? "" : "s";
        String typeList = emptyTypes.stream().map(Object::toString).collect(Collectors.joining(","));
        return String.format("Indexing of type%s %s %s", s, typeList, suffix);
    }
}

