/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.es;

import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.elasticsearch.action.admin.indices.stats.IndexStats;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsResponse;
import org.sonar.api.utils.log.Loggers;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.server.es.EsClient;
import org.sonar.server.platform.db.migration.es.MigrationEsClient;

public class MigrationEsClientImpl
implements MigrationEsClient {
    private final EsClient client;

    public MigrationEsClientImpl(EsClient client) {
        this.client = client;
    }

    public void deleteIndexes(String name, String ... otherNames) {
        Map indices = ((IndicesStatsResponse)this.client.nativeClient().admin().indices().prepareStats(new String[0]).get()).getIndices();
        Set existingIndices = (Set)indices.values().stream().map(IndexStats::getIndex).collect(MoreCollectors.toSet());
        Stream.concat(Stream.of(name), Arrays.stream(otherNames)).distinct().filter(existingIndices::contains).forEach(this::deleteIndex);
    }

    private void deleteIndex(String index) {
        Loggers.get(this.getClass()).info("Drop Elasticsearch index [{}]", (Object)index);
        this.client.nativeClient().admin().indices().prepareDelete(new String[]{index}).get();
    }
}

