/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.favorite.ws;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import org.sonar.api.server.ws.Change;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.server.component.ComponentFinder;
import org.sonar.server.favorite.FavoriteUpdater;
import org.sonar.server.favorite.ws.FavoritesWsAction;
import org.sonar.server.user.UserSession;

public class AddAction
implements FavoritesWsAction {
    private static final List<String> SUPPORTED_QUALIFIERS = Arrays.asList("TRK", "VW", "SVW", "APP", "FIL", "UTS");
    private static final String SUPPORTED_QUALIFIERS_AS_STRING = String.join((CharSequence)", ", SUPPORTED_QUALIFIERS);
    private final UserSession userSession;
    private final DbClient dbClient;
    private final FavoriteUpdater favoriteUpdater;
    private final ComponentFinder componentFinder;

    public AddAction(UserSession userSession, DbClient dbClient, FavoriteUpdater favoriteUpdater, ComponentFinder componentFinder) {
        this.userSession = userSession;
        this.dbClient = dbClient;
        this.favoriteUpdater = favoriteUpdater;
        this.componentFinder = componentFinder;
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction("add").setDescription("Add a component (project, file etc.) as favorite for the authenticated user.<br>Only 100 components by qualifier can be added as favorite.<br>Requires authentication and the following permission: 'Browse' on the project of the specified component.").setSince("6.3").setChangelog(new Change[]{new Change("7.7", "It's no longer possible to have more than 100 favorites by qualifier"), new Change("7.7", "It's no longer possible to set a directory as favorite"), new Change("7.6", String.format("The use of module keys in parameter '%s' is deprecated", "component"))}).setPost(true).setHandler((RequestHandler)this);
        action.createParam("component").setDescription(String.format("Component key. Only components with qualifiers %s are supported", SUPPORTED_QUALIFIERS_AS_STRING)).setRequired(true).setExampleValue((Object)"my_project:/src/foo/Bar.php");
    }

    public void handle(Request request, Response response) throws Exception {
        this.addFavorite().accept(request);
        response.noContent();
    }

    private Consumer<Request> addFavorite() {
        return request -> {
            try (DbSession dbSession = this.dbClient.openSession(false);){
                ComponentDto componentDto = this.componentFinder.getByKey(dbSession, request.mandatoryParam("component"));
                Preconditions.checkArgument((boolean)SUPPORTED_QUALIFIERS.contains(componentDto.qualifier()), (String)"Only components with qualifiers %s are supported", (Object[])new Object[]{SUPPORTED_QUALIFIERS_AS_STRING});
                this.userSession.checkLoggedIn().checkComponentPermission("user", componentDto);
                this.favoriteUpdater.add(dbSession, componentDto, this.userSession.isLoggedIn() ? this.userSession.getUserId() : null, true);
                dbSession.commit();
            }
        };
    }
}

