/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.issue;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Collection;
import java.util.Map;
import org.sonar.api.issue.Issue;
import org.sonar.api.rules.RuleType;
import org.sonar.core.issue.DefaultIssue;
import org.sonar.server.issue.Action;
import org.sonar.server.issue.IssueFieldsSetter;
import org.sonar.server.issue.workflow.Condition;
import org.sonar.server.issue.workflow.IsUnResolved;
import org.sonar.server.user.UserSession;

public class SetTypeAction
extends Action {
    public static final String SET_TYPE_KEY = "set_type";
    public static final String TYPE_PARAMETER = "type";
    private final IssueFieldsSetter issueUpdater;
    private final UserSession userSession;

    public SetTypeAction(IssueFieldsSetter issueUpdater, UserSession userSession) {
        super(SET_TYPE_KEY);
        this.issueUpdater = issueUpdater;
        this.userSession = userSession;
        super.setConditions(new Condition[]{new IsUnResolved(), this::isCurrentUserIssueAdmin});
    }

    private boolean isCurrentUserIssueAdmin(Issue issue) {
        return !((DefaultIssue)issue).isFromHotspot() && this.userSession.hasComponentUuidPermission("issueadmin", issue.projectUuid());
    }

    @Override
    public boolean verify(Map<String, Object> properties, Collection<DefaultIssue> issues, UserSession userSession) {
        SetTypeAction.verifyTypeParameter(properties);
        return true;
    }

    @Override
    public boolean execute(Map<String, Object> properties, Action.Context context) {
        String type = SetTypeAction.verifyTypeParameter(properties);
        return this.issueUpdater.setType(context.issue(), RuleType.valueOf((String)type), context.issueChangeContext());
    }

    @Override
    public boolean shouldRefreshMeasures() {
        return true;
    }

    private static String verifyTypeParameter(Map<String, Object> properties) {
        String type = (String)properties.get(TYPE_PARAMETER);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)type) ? 1 : 0) != 0, (String)"Missing parameter : '%s'", (Object[])new Object[]{TYPE_PARAMETER});
        Preconditions.checkArgument((boolean)RuleType.names().contains(type), (String)"Unknown type : %s", (Object[])new Object[]{type});
        return type;
    }
}

