/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.issue;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.CheckForNull;
import org.sonar.api.issue.Issue;
import org.sonar.api.rules.Rule;
import org.sonar.api.rules.RuleFinder;
import org.sonar.api.server.ServerSide;
import org.sonar.api.utils.System2;
import org.sonar.core.issue.DefaultIssue;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.issue.IssueChangeMapper;
import org.sonar.db.issue.IssueDto;
import org.sonar.server.issue.IssueStorage;
import org.sonar.server.issue.index.IssueIndexer;

@ServerSide
public class WebIssueStorage
extends IssueStorage {
    private final System2 system2;
    private final RuleFinder ruleFinder;
    private final DbClient dbClient;
    private final IssueIndexer indexer;

    public WebIssueStorage(System2 system2, DbClient dbClient, RuleFinder ruleFinder, IssueIndexer indexer) {
        this.system2 = system2;
        this.dbClient = dbClient;
        this.ruleFinder = ruleFinder;
        this.indexer = indexer;
    }

    protected DbClient getDbClient() {
        return this.dbClient;
    }

    public Collection<IssueDto> save(DbSession dbSession, Iterable<DefaultIssue> issues) {
        long now = this.system2.now();
        Map<Boolean, List<DefaultIssue>> issuesNewOrUpdated = StreamSupport.stream(issues.spliterator(), true).collect(Collectors.groupingBy(DefaultIssue::isNew));
        List issuesToInsert = (List)MoreObjects.firstNonNull(issuesNewOrUpdated.get(true), Collections.emptyList());
        List issuesToUpdate = (List)MoreObjects.firstNonNull(issuesNewOrUpdated.get(false), Collections.emptyList());
        Collection<IssueDto> inserted = this.insert(dbSession, issuesToInsert, now);
        Collection<IssueDto> updated = this.update(issuesToUpdate, now);
        this.doAfterSave(dbSession, (Collection)Stream.concat(inserted.stream(), updated.stream()).collect(MoreCollectors.toSet((int)(issuesToInsert.size() + issuesToUpdate.size()))));
        return (Collection)Stream.concat(inserted.stream(), updated.stream()).collect(MoreCollectors.toSet((int)(issuesToInsert.size() + issuesToUpdate.size())));
    }

    private void doAfterSave(DbSession dbSession, Collection<IssueDto> issues) {
        this.indexer.commitAndIndexIssues(dbSession, issues);
    }

    private Collection<IssueDto> insert(DbSession session, Iterable<DefaultIssue> issuesToInsert, long now) {
        ArrayList inserted = Lists.newArrayList();
        int count = 0;
        IssueChangeMapper issueChangeMapper = (IssueChangeMapper)session.getMapper(IssueChangeMapper.class);
        for (DefaultIssue issue : issuesToInsert) {
            IssueDto issueDto = this.doInsert(session, now, issue);
            inserted.add(issueDto);
            this.insertChanges(issueChangeMapper, issue);
            if (count > 250) {
                session.commit();
                count = 0;
            }
            ++count;
        }
        session.commit();
        return inserted;
    }

    private IssueDto doInsert(DbSession session, long now, DefaultIssue issue) {
        ComponentDto component = this.component(session, issue);
        ComponentDto project = this.project(session, issue);
        int ruleId = Objects.requireNonNull(this.getRuleId((Issue)issue), "Rule not found: " + issue.ruleKey());
        IssueDto dto = IssueDto.toDtoForServerInsert((DefaultIssue)issue, (ComponentDto)component, (ComponentDto)project, (int)ruleId, (long)now);
        this.getDbClient().issueDao().insert(session, dto);
        return dto;
    }

    ComponentDto component(DbSession session, DefaultIssue issue) {
        return this.getDbClient().componentDao().selectOrFailByUuid(session, issue.componentUuid());
    }

    ComponentDto project(DbSession session, DefaultIssue issue) {
        return this.getDbClient().componentDao().selectOrFailByUuid(session, issue.projectUuid());
    }

    private Collection<IssueDto> update(List<DefaultIssue> issuesToUpdate, long now) {
        ArrayList<IssueDto> updated = new ArrayList<IssueDto>();
        if (!issuesToUpdate.isEmpty()) {
            try (DbSession dbSession = this.dbClient.openSession(false);){
                IssueChangeMapper issueChangeMapper = (IssueChangeMapper)dbSession.getMapper(IssueChangeMapper.class);
                for (DefaultIssue issue : issuesToUpdate) {
                    IssueDto issueDto = this.doUpdate(dbSession, now, issue);
                    updated.add(issueDto);
                    this.insertChanges(issueChangeMapper, issue);
                }
                dbSession.commit();
            }
        }
        return updated;
    }

    private IssueDto doUpdate(DbSession session, long now, DefaultIssue issue) {
        IssueDto dto = IssueDto.toDtoForUpdate((DefaultIssue)issue, (long)now);
        this.getDbClient().issueDao().update(session, dto);
        Integer ruleId = this.getRuleId((Issue)issue);
        return dto.setRuleId(ruleId);
    }

    @CheckForNull
    protected Integer getRuleId(Issue issue) {
        Rule rule = this.ruleFinder.findByKey(issue.ruleKey());
        return rule != null ? rule.getId() : null;
    }
}

